/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.Serializable;
import junit.framework.TestCase;
import org.alfresco.filesys.repo.LockKeeper;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class LockKeeperImplTest
extends TestCase {
    private static Log logger = LogFactory.getLog(LockKeeperImplTest.class);
    private ApplicationContext applicationContext;
    private LockKeeper lockKeeper;
    private NodeService nodeService;
    private Repository repositoryHelper;
    private TransactionService transactionService;

    protected void setUp() throws Exception {
        this.applicationContext = ApplicationContextHelper.getApplicationContext();
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.repositoryHelper = (Repository)this.applicationContext.getBean("repositoryHelper");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionService");
        ChildApplicationContextFactory fileServersSubSystem = (ChildApplicationContextFactory)this.applicationContext.getBean("fileServers");
        LockKeeperImplTest.assertNotNull((String)"fileServers subsystem is null", (Object)fileServersSubSystem);
        this.lockKeeper = (LockKeeper)fileServersSubSystem.getApplicationContext().getBean("lockKeeper");
        LockKeeperImplTest.assertNotNull((String)"nodeService is null", (Object)this.nodeService);
        LockKeeperImplTest.assertNotNull((String)"lockKeeper is null", (Object)this.lockKeeper);
        LockKeeperImplTest.assertNotNull((String)"transactionService is null", (Object)this.transactionService);
        AuthenticationUtil.setRunAsUserSystem();
        AuthenticationUtil.setFullyAuthenticatedUser((String)"bugsBunny");
    }

    public void testBasicLockUnlock() throws Exception {
        logger.debug((Object)"testBasicLockUnlock");
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Boolean> lockCB = new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

            public Boolean execute() throws Throwable {
                NodeRef companyHome = LockKeeperImplTest.this.repositoryHelper.getCompanyHome();
                NodeRef nodeRef = LockKeeperImplTest.this.nodeService.getChildByName(companyHome, ContentModel.ASSOC_CONTAINS, "LockKeeperImplTestNode");
                if (nodeRef == null) {
                    ChildAssociationRef ref = LockKeeperImplTest.this.nodeService.createNode(companyHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"LockKeeperImplTestNode"), ContentModel.TYPE_CONTENT);
                    LockKeeperImplTest.this.nodeService.setProperty(ref.getChildRef(), ContentModel.PROP_NAME, (Serializable)((Object)"LockKeeperImplTestNode"));
                    nodeRef = ref.getChildRef();
                }
                logger.debug((Object)"first lock");
                LockKeeperImplTest.this.lockKeeper.addLock(nodeRef);
                boolean locked = LockKeeperImplTest.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE);
                return locked;
            }
        };
        boolean locked = (Boolean)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)lockCB);
        LockKeeperImplTest.assertTrue((String)"node not locked", (boolean)locked);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> refreshCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                logger.debug((Object)"first refresh");
                LockKeeperImplTest.this.lockKeeper.refreshAllLocks();
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)refreshCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Boolean> removeCB = new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

            public Boolean execute() throws Throwable {
                NodeRef companyHome = LockKeeperImplTest.this.repositoryHelper.getCompanyHome();
                NodeRef nodeRef = LockKeeperImplTest.this.nodeService.getChildByName(companyHome, ContentModel.ASSOC_CONTAINS, "LockKeeperImplTestNode");
                LockKeeperImplTest.this.lockKeeper.removeLock(nodeRef);
                boolean locked = LockKeeperImplTest.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE);
                return locked;
            }
        };
        locked = (Boolean)tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)removeCB);
        LockKeeperImplTest.assertFalse((String)"node not unlocked", (boolean)locked);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> refreshAgainCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                logger.debug((Object)"second refresh");
                LockKeeperImplTest.this.lockKeeper.refreshAllLocks();
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)refreshAgainCB);
    }

    public void testBasicLockUnlockSeparateTrans() throws Exception {
        logger.debug((Object)"testBasicLockUnlock");
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        class TestContext {
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> lockCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                String FILE_NAME = "LockKeeperImplTestNode";
                NodeRef companyHome = LockKeeperImplTest.this.repositoryHelper.getCompanyHome();
                NodeRef nodeRef = LockKeeperImplTest.this.nodeService.getChildByName(companyHome, ContentModel.ASSOC_CONTAINS, FILE_NAME);
                if (nodeRef == null) {
                    ChildAssociationRef ref = LockKeeperImplTest.this.nodeService.createNode(companyHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)FILE_NAME), ContentModel.TYPE_CONTENT);
                    LockKeeperImplTest.this.nodeService.setProperty(ref.getChildRef(), ContentModel.PROP_NAME, (Serializable)((Object)FILE_NAME));
                    nodeRef = ref.getChildRef();
                }
                logger.debug((Object)"first lock");
                LockKeeperImplTest.this.lockKeeper.addLock(nodeRef);
                LockKeeperImplTest.assertTrue((String)"node not locked", (boolean)LockKeeperImplTest.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE));
                testContext.testNodeRef = nodeRef;
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)lockCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> unlockCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            public Void execute() throws Throwable {
                logger.debug((Object)"remove lock");
                LockKeeperImplTest.this.lockKeeper.removeLock(testContext.testNodeRef);
                LockKeeperImplTest.assertFalse((String)"node not unlocked", (boolean)LockKeeperImplTest.this.nodeService.hasAspect(testContext.testNodeRef, ContentModel.ASPECT_LOCKABLE));
                return null;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> refreshCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                logger.debug((Object)"refresh locks");
                LockKeeperImplTest.this.lockKeeper.refreshAllLocks();
                return null;
            }
        };
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)lockCB);
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)refreshCB);
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)unlockCB);
        tran.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)refreshCB);
    }
}

