/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import org.alfresco.repo.virtual.ref.ClasspathResource;
import org.alfresco.repo.virtual.ref.HashEncodingArtefact;
import org.alfresco.repo.virtual.ref.HashStore;
import org.alfresco.repo.virtual.ref.NodeRefHasher;
import org.alfresco.repo.virtual.ref.NodeRefRadixHasher;
import org.alfresco.repo.virtual.ref.PathHasher;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.ReferenceParseException;
import org.alfresco.repo.virtual.ref.ReferenceParser;
import org.alfresco.repo.virtual.ref.RepositoryNodeRef;
import org.alfresco.repo.virtual.ref.RepositoryPath;
import org.alfresco.repo.virtual.ref.RepositoryResource;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.StoredPathHasher;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;

public abstract class ProtocolHashParser
implements HashEncodingArtefact {
    private NodeRefHasher nodeRefHasher = NodeRefRadixHasher.RADIX_36_HASHER;
    private PathHasher classpathHasher;
    private PathHasher repositoryPathHasher;

    protected abstract Reference parse(ReferenceParser.Cursor var1) throws ReferenceParseException;

    public ProtocolHashParser(HashStore classpathHashStore) {
        this.classpathHasher = new StoredPathHasher(classpathHashStore);
        this.repositoryPathHasher = new StoredPathHasher(classpathHashStore);
    }

    protected Resource parseResource(ReferenceParser.Cursor cursor) throws ReferenceParseException {
        String token = cursor.nextToken();
        if ("1".equals(token)) {
            String nodeRefHash = cursor.nextToken();
            String storeHash = nodeRefHash.substring(0, 2);
            String nodeIdHash = nodeRefHash.substring(2);
            NodeRef nodeRef = this.nodeRefHasher.lookup((Pair<String, String>)new Pair((Object)storeHash, (Object)nodeIdHash));
            return new RepositoryResource(new RepositoryNodeRef(nodeRef));
        }
        if ("6".equals(token)) {
            String cp = this.classpathHasher.lookup((Pair<String, String>)new Pair((Object)cursor.nextToken(), null));
            return new ClasspathResource(cp);
        }
        if ("7".equals(token)) {
            String cp = this.classpathHasher.lookup((Pair<String, String>)new Pair((Object)cursor.nextToken(), (Object)cursor.nextToken()));
            return new ClasspathResource(cp);
        }
        if ("5".equals(token)) {
            String cp = this.classpathHasher.lookup((Pair<String, String>)new Pair(null, (Object)cursor.nextToken()));
            return new ClasspathResource(cp);
        }
        if ("3".equals(token)) {
            String path = this.repositoryPathHasher.lookup((Pair<String, String>)new Pair((Object)cursor.nextToken(), null));
            return new RepositoryResource(new RepositoryPath(path));
        }
        if ("4".equals(token)) {
            String path = this.repositoryPathHasher.lookup((Pair<String, String>)new Pair((Object)cursor.nextToken(), (Object)cursor.nextToken()));
            return new RepositoryResource(new RepositoryPath(path));
        }
        if ("2".equals(token)) {
            String path = this.repositoryPathHasher.lookup((Pair<String, String>)new Pair(null, (Object)cursor.nextToken()));
            return new RepositoryResource(new RepositoryPath(path));
        }
        throw new ReferenceParseException("Unknown resource token " + token + " at " + cursor.i--);
    }
}

