/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.filestore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashSet;
import java.util.zip.CRC32;
import junit.framework.TestCase;
import org.alfresco.util.TempFileProvider;

public class FileIOTest
extends TestCase {
    private static final String TEST_CONTENT = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private File file;

    public FileIOTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.file = TempFileProvider.createTempFile((String)this.getName(), (String)".txt");
        FileOutputStream os = new FileOutputStream(this.file);
        ((OutputStream)os).write(TEST_CONTENT.getBytes());
        os.flush();
        ((OutputStream)os).close();
    }

    public void testConcurrentFileReads() throws Exception {
        FileInputStream isA = new FileInputStream(this.file);
        FileInputStream isB = new FileInputStream(this.file);
        FileChannel channelA = isA.getChannel();
        FileChannel channelB = isB.getChannel();
        ByteBuffer bufferA = ByteBuffer.allocate(10);
        ByteBuffer bufferB = ByteBuffer.allocate(10);
        int countA = 0;
        int countB = 0;
        do {
            ((Buffer)bufferA).clear();
            countA = channelA.read(bufferA);
            ((Buffer)bufferB).clear();
            countB = channelB.read(bufferB);
            FileIOTest.assertEquals((String)"Should read same number of bytes", (int)countA, (int)countB);
        } while (countA > 6);
        FileIOTest.assertEquals((String)"BufferA marker incorrect", (int)6, (int)bufferA.position());
        FileIOTest.assertEquals((String)"BufferB marker incorrect", (int)6, (int)bufferB.position());
    }

    public void testConcurrentReadWrite() throws Exception {
        FileInputStream isRead = new FileInputStream(this.file);
        FileOutputStream osWrite = new FileOutputStream(this.file);
        FileChannel channelRead = isRead.getChannel();
        FileChannel channelWrite = osWrite.getChannel();
        ByteBuffer bufferRead = ByteBuffer.allocate(26);
        ByteBuffer bufferWrite = ByteBuffer.wrap(TEST_CONTENT.getBytes());
        int countRead = channelRead.read(bufferRead);
        FileIOTest.assertEquals((String)"Expected nothing to be read", (int)-1, (int)countRead);
        int countWrite = channelWrite.write(bufferWrite);
        FileIOTest.assertEquals((String)"Not all characters written", (int)26, (int)countWrite);
        channelWrite.close();
        countRead = channelRead.read(bufferRead);
        FileIOTest.assertEquals((String)"Expected full read", (int)26, (int)countRead);
    }

    public void testCrcPerformance() throws Exception {
        long before = System.nanoTime();
        int count = 1000000;
        HashSet<Long> results = new HashSet<Long>(count);
        boolean negatives = false;
        int i = 0;
        while (i < count) {
            CRC32 crc = new CRC32();
            crc.update(Integer.toString(i).getBytes());
            long value = crc.getValue();
            if (value < 0L) {
                negatives = true;
            }
            if (!results.add(value)) {
                System.out.println("Duplicate on " + i);
            }
            ++i;
        }
        long after = System.nanoTime();
        long delta = after - before;
        double aveNs = (double)delta / (double)count;
        System.out.println(String.format("CRC32: %10.2f ns per item.  Negatives=" + negatives, aveNs));
    }
}

