/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.server.impl.subetha;

import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.Session;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimeUtility;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.alfresco.email.server.impl.subetha.SubethaEmailMessagePart;
import org.alfresco.service.cmr.email.EmailMessage;
import org.alfresco.service.cmr.email.EmailMessageException;
import org.alfresco.service.cmr.email.EmailMessagePart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SubethaEmailMessage
implements EmailMessage {
    private static final String ERR_FAILED_TO_CREATE_MIME_MESSAGE = "email.server.err.failed_to_create_mime_message";
    private static final String ERR_EXTRACTING_FROM_ADDRESS = "email.server.err.extracting_from_address";
    private static final String ERR_NO_FROM_ADDRESS = "email.server.err.no_from_address";
    private static final String ERR_EXTRACTING_TO_ADDRESS = "email.server.err.extracting_to_address";
    private static final String ERR_NO_TO_ADDRESS = "email.server.err.no_to_address";
    private static final String ERR_EXTRACTING_SUBJECT = "email.server.err.extracting_subject";
    private static final String ERR_EXTRACTING_SENT_DATE = "email.server.err.extracting_sent_date";
    private static final String ERR_PARSE_MESSAGE = "email.server.err.parse_message";
    private static final long serialVersionUID = -3735187524926395261L;
    private static final Log log = LogFactory.getLog(SubethaEmailMessage.class);
    private static final String MIME_PLAIN_TEXT = "text/plain";
    private static final String MIME_HTML_TEXT = "text/html";
    private static final String MIME_XML_TEXT = "text/xml";
    private static final String MIME_APPLICATION = "application/*";
    private static final String MIME_IMAGE = "image/*";
    private static final String MIME_MULTIPART = "multipart/*";
    private static final String MIME_RFC822 = "message/rfc822";
    private static final String FILENAME_ATTACHMENT_PREFIX = "Attachment";
    private String from;
    private String to;
    private String subject;
    private List<String> cc;
    private Date sentDate;
    private EmailMessagePart body;
    private EmailMessagePart[] attachments;
    private transient int bodyNumber = 0;
    private transient int attachmentNumber = 0;
    private transient List<EmailMessagePart> attachmentList = new LinkedList<EmailMessagePart>();

    protected SubethaEmailMessage() {
    }

    public SubethaEmailMessage(MimeMessage mimeMessage) {
        this.processMimeMessage(mimeMessage);
    }

    public SubethaEmailMessage(InputStream dataInputStream) {
        MimeMessage mimeMessage = null;
        try {
            mimeMessage = new MimeMessage(Session.getDefaultInstance((Properties)System.getProperties()), dataInputStream);
        }
        catch (MessagingException e) {
            throw new EmailMessageException(ERR_FAILED_TO_CREATE_MIME_MESSAGE, e.getMessage());
        }
        this.processMimeMessage(mimeMessage);
    }

    private void processMimeMessage(MimeMessage mimeMessage) {
        Address[] addresses;
        if (this.from == null) {
            addresses = null;
            try {
                addresses = mimeMessage.getFrom();
            }
            catch (MessagingException e) {
                throw new EmailMessageException(ERR_EXTRACTING_FROM_ADDRESS, e.getMessage());
            }
            if (addresses != null && addresses.length != 0) {
                this.from = addresses[0] instanceof InternetAddress ? ((InternetAddress)addresses[0]).getAddress() : addresses[0].toString();
            }
        }
        if (this.to == null) {
            addresses = null;
            try {
                addresses = mimeMessage.getAllRecipients();
            }
            catch (MessagingException e) {
                throw new EmailMessageException(ERR_EXTRACTING_TO_ADDRESS, e.getMessage());
            }
            if (addresses != null && addresses.length != 0) {
                this.to = addresses[0] instanceof InternetAddress ? ((InternetAddress)addresses[0]).getAddress() : addresses[0].toString();
            }
        }
        if (this.cc == null) {
            try {
                ArrayList<String> list = new ArrayList<String>();
                Address[] cca = mimeMessage.getRecipients(Message.RecipientType.CC);
                if (cca != null) {
                    Address[] addressArray = cca;
                    int n = cca.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Address a = addressArray[n2];
                        list.add(a.toString());
                        ++n2;
                    }
                }
                this.cc = list;
            }
            catch (MessagingException messagingException) {
                this.cc = null;
            }
        }
        try {
            this.subject = mimeMessage.getSubject();
        }
        catch (MessagingException e) {
            throw new EmailMessageException(ERR_EXTRACTING_SUBJECT, e.getMessage());
        }
        try {
            this.sentDate = mimeMessage.getSentDate();
        }
        catch (MessagingException e) {
            throw new EmailMessageException(ERR_EXTRACTING_SENT_DATE, e.getMessage());
        }
        if (this.sentDate == null) {
            this.sentDate = new Date();
        }
        this.parseMessagePart((Part)mimeMessage);
        this.attachments = new EmailMessagePart[this.attachmentList.size()];
        this.attachmentList.toArray(this.attachments);
        this.attachmentList = null;
    }

    private void parseMessagePart(Part messagePart) {
        try {
            if (messagePart.isMimeType(MIME_PLAIN_TEXT) || messagePart.isMimeType(MIME_HTML_TEXT)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Text or HTML part was found. ContentType: " + messagePart.getContentType()));
                }
                this.addBody(messagePart);
            } else if (messagePart.isMimeType(MIME_XML_TEXT)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"XML part was found.");
                }
                this.addAttachment(messagePart);
            } else if (messagePart.isMimeType(MIME_APPLICATION)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Application part was found.");
                }
                this.addAttachment(messagePart);
            } else if (messagePart.isMimeType(MIME_IMAGE)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Image part was found.");
                }
                this.addAttachment(messagePart);
            } else if (messagePart.isMimeType(MIME_MULTIPART)) {
                Multipart mp = (Multipart)messagePart.getContent();
                int count = mp.getCount();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("MULTIPART with " + count + " part(s) found. Processin each part..."));
                }
                int i = 0;
                while (i < count) {
                    BodyPart bp = mp.getBodyPart(i);
                    if (bp.getContent() instanceof MimeMultipart) {
                        this.parseMessagePart((Part)bp);
                    } else {
                        this.addBody((Part)bp);
                    }
                    ++i;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"MULTIPART processed.");
                }
            } else if (messagePart.isMimeType(MIME_RFC822)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"MIME_RFC822 part found. Processing inside part...");
                }
                this.parseMessagePart((Part)messagePart.getContent());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"MIME_RFC822 processed.");
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Unrecognized part was found. Put it into attachments.");
                }
                this.addAttachment(messagePart);
            }
        }
        catch (IOException e) {
            throw new EmailMessageException(ERR_PARSE_MESSAGE, e.getMessage());
        }
        catch (MessagingException e) {
            throw new EmailMessageException(ERR_PARSE_MESSAGE, e.getMessage());
        }
    }

    private void addBody(Part messagePart) throws MessagingException {
        if (this.body != null) {
            this.attachmentList.add(new SubethaEmailMessagePart(messagePart, this.getPartFileName(this.getSubject() + " (part " + ++this.bodyNumber + ")", messagePart)));
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Attachment \"%s\" has been added.", this.attachmentList.get(this.attachmentList.size() - 1).getFileName()));
            }
        } else {
            this.body = new SubethaEmailMessagePart(messagePart, this.getPartFileName(this.getSubject(), messagePart));
            if (log.isDebugEnabled()) {
                log.debug((Object)"Body has been added.");
            }
        }
    }

    private void addAttachment(Part messagePart) throws MessagingException {
        String fileName = this.getPartFileName(FILENAME_ATTACHMENT_PREFIX + this.attachmentNumber, messagePart);
        this.attachmentList.add(new SubethaEmailMessagePart(messagePart, fileName));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attachment added: " + fileName));
        }
    }

    private String getPartFileName(String defaultPrefix, Part messagePart) throws MessagingException {
        Object fileName = messagePart.getFileName();
        if (fileName != null) {
            try {
                fileName = MimeUtility.decodeText((String)fileName);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            fileName = defaultPrefix;
            if (messagePart.isMimeType(MIME_PLAIN_TEXT)) {
                fileName = (String)fileName + ".txt";
            } else if (messagePart.isMimeType(MIME_HTML_TEXT)) {
                fileName = (String)fileName + ".html";
            } else if (messagePart.isMimeType(MIME_XML_TEXT)) {
                fileName = (String)fileName + ".xml";
            } else if (messagePart.isMimeType(MIME_IMAGE)) {
                fileName = (String)fileName + ".gif";
            }
        }
        return fileName;
    }

    @Override
    public List<String> getCC() {
        return this.cc;
    }

    @Override
    public String getFrom() {
        return this.from;
    }

    @Override
    public String getTo() {
        return this.to;
    }

    @Override
    public Date getSentDate() {
        return this.sentDate;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public EmailMessagePart getBody() {
        return this.body;
    }

    @Override
    public EmailMessagePart[] getAttachments() {
        return this.attachments;
    }
}

