/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.exporter;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.view.RepositoryExporterService;
import org.alfresco.util.BaseSpringTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.test.annotation.Commit;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class RepositoryExporterComponentTest
extends BaseSpringTest {
    private RepositoryExporterService repositoryService;
    private AuthenticationComponent authenticationComponent;
    private NodeService nodeService;
    private FileFolderService fileFolderService;

    @Before
    public void before() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean(ServiceRegistry.NODE_SERVICE.getLocalName());
        this.fileFolderService = (FileFolderService)this.applicationContext.getBean(ServiceRegistry.FILE_FOLDER_SERVICE.getLocalName());
        this.repositoryService = (RepositoryExporterService)this.applicationContext.getBean("repositoryExporterComponent");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
    }

    @After
    public void after() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    @Test
    public void testDummy() {
    }

    public void xtestTempFileExport() throws Exception {
        RepositoryExporterService.FileExportHandle[] handles = this.repositoryService.export("test");
        RepositoryExporterComponentTest.assertNotNull((Object)handles);
        RepositoryExporterComponentTest.assertEquals((int)6, (int)handles.length);
        RepositoryExporterService.FileExportHandle[] fileExportHandleArray = handles;
        int n = handles.length;
        int n2 = 0;
        while (n2 < n) {
            RepositoryExporterService.FileExportHandle tempFile = fileExportHandleArray[n2];
            RepositoryExporterComponentTest.assertTrue((boolean)tempFile.exportFile.exists());
            ++n2;
        }
    }

    @Ignore
    @Commit
    @Test
    public void testRepositoryExport() {
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        NodeRef rootNode = this.nodeService.getRootNode(storeRef);
        FileInfo container = this.fileFolderService.create(rootNode, "export", ContentModel.TYPE_FOLDER);
        RepositoryExporterService.RepositoryExportHandle[] handles = this.repositoryService.export(container.getNodeRef(), "test");
        RepositoryExporterComponentTest.assertNotNull((Object)handles);
        RepositoryExporterComponentTest.assertEquals((int)6, (int)handles.length);
        RepositoryExporterService.RepositoryExportHandle[] repositoryExportHandleArray = handles;
        int n = handles.length;
        int n2 = 0;
        while (n2 < n) {
            RepositoryExporterService.RepositoryExportHandle handle = repositoryExportHandleArray[n2];
            RepositoryExporterComponentTest.assertTrue((boolean)this.nodeService.exists(handle.exportFile));
            ++n2;
        }
    }
}

