/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.remote.server.socket;

import java.io.IOException;
import java.io.Serializable;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostConfigurableSocketFactory
implements RMIServerSocketFactory,
RMIClientSocketFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(HostConfigurableSocketFactory.class);
    private int retries = 0;
    private int retryInterval = 250;
    private InetAddress host;

    public void setHost(String host) {
        try {
            InetAddress hostAddress = InetAddress.getByName(host);
            if (!hostAddress.isAnyLocalAddress()) {
                this.host = hostAddress;
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return new Socket(host, port);
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket socket = null;
        int i = 0;
        while (socket == null && i < this.retries + 1) {
            try {
                socket = new ServerSocket(port, 50, this.host);
            }
            catch (BindException e) {
                if (i >= this.retries) {
                    if (logger.isErrorEnabled()) {
                        logger.error((Object)("Failed to create server socket on port " + port + ", tried " + (i + 1) + " times."));
                    }
                    throw e;
                }
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Port " + port + " in-use, will retry after " + this.retryInterval + " millis (was attempt #" + (i + 1) + ")"));
                }
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++i;
        }
        return socket;
    }

    public boolean equals(Object obj) {
        return obj instanceof HostConfigurableSocketFactory && EqualsHelper.nullSafeEquals((Object)this.host, (Object)((HostConfigurableSocketFactory)obj).host);
    }

    public int hashCode() {
        return this.host == null ? 0 : this.host.hashCode();
    }
}

