/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.store;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.virtual.ActualEnvironment;
import org.alfresco.repo.virtual.ActualEnvironmentException;
import org.alfresco.repo.virtual.VirtualizationException;
import org.alfresco.repo.virtual.ref.NewVirtualReferenceMethod;
import org.alfresco.repo.virtual.ref.Protocol;
import org.alfresco.repo.virtual.ref.ProtocolMethodException;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.VirtualProtocol;
import org.alfresco.repo.virtual.store.VirtualizationMethod;
import org.alfresco.service.cmr.repository.NodeRef;

public abstract class TemplateVirtualizationMethod
implements VirtualizationMethod {
    protected static final String PATH_SEPARATOR = "/";
    private String vanillaProcessorClasspath;

    public void setVanillaProcessor(String vanillaProcessorClasspath) {
        this.vanillaProcessorClasspath = vanillaProcessorClasspath;
    }

    protected Reference newVirtualReference(ActualEnvironment env, NodeRef actualNodeRef, String templateSystemPath) throws VirtualizationException {
        char systemToken = templateSystemPath.charAt(0);
        if (systemToken == VirtualProtocol.NODE_TEMPLATE_PATH_TOKEN.charValue()) {
            return this.newVirtualReference(env, actualNodeRef, new NodeRef(templateSystemPath.substring(1)));
        }
        String templateName = this.retrieveTemplateContentName(env, templateSystemPath);
        if (!templateName.isEmpty()) {
            Protocol protocol = this.protocolFormName(templateName);
            return protocol.dispatch(new NewVirtualReferenceMethod(templateSystemPath, PATH_SEPARATOR, actualNodeRef, this.vanillaProcessorClasspath), null);
        }
        throw new VirtualizationException("Invalid virtualization : missing template name for " + templateSystemPath);
    }

    protected Reference newVirtualReference(ActualEnvironment env, NodeRef actualNodeRef, NodeRef templateRef) throws VirtualizationException {
        String templateName = this.retrieveTemplateContentName(env, templateRef);
        if (templateName != null) {
            Protocol protocol = this.protocolFormName(templateName);
            return this.newVirtualReference(protocol, templateRef, actualNodeRef);
        }
        throw new VirtualizationException("Invalid virtualization : missing template name for " + String.valueOf(templateRef));
    }

    protected Reference newVirtualReference(Protocol protocol, NodeRef templateRef, NodeRef actualNodeRef) throws ProtocolMethodException {
        return protocol.dispatch(new NewVirtualReferenceMethod(templateRef, PATH_SEPARATOR, actualNodeRef, this.vanillaProcessorClasspath), null);
    }

    private String retrieveTemplateContentName(ActualEnvironment env, String sysPath) throws ActualEnvironmentException {
        int index = sysPath.lastIndexOf(PATH_SEPARATOR);
        if (index < 0) {
            index = 1;
        }
        return sysPath.substring(index);
    }

    private String retrieveTemplateContentName(ActualEnvironment env, NodeRef templateRef) throws ActualEnvironmentException {
        String templateName = (String)((Object)env.getProperty(templateRef, ContentModel.PROP_NAME));
        return templateName;
    }

    private final Protocol protocolFormName(String name) throws VirtualizationException {
        if (name.toUpperCase().endsWith(".JS")) {
            return Protocols.VIRTUAL.protocol;
        }
        if (name.toUpperCase().endsWith(".JSON")) {
            return Protocols.VANILLA.protocol;
        }
        throw new VirtualizationException("Invalid template script file .extension for " + name);
    }
}

