/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.repo.template.TemplateProcessorMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.dtm.ref.DTMNodeProxy;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class XSLTProcessorMethodInvoker {
    private static final Log log = LogFactory.getLog(XSLTProcessorMethodInvoker.class);
    private static final Map<String, TemplateProcessorMethod> PROCESSOR_METHODS = new TreeMap<String, TemplateProcessorMethod>();

    public static void addMethod(String name, TemplateProcessorMethod method) {
        PROCESSOR_METHODS.put(name, method);
    }

    public static void removeMethods(Collection<String> methodNames) {
        for (String methodName : methodNames) {
            PROCESSOR_METHODS.remove(methodName);
        }
    }

    private Object[] convertArguments(Object[] arguments) {
        LinkedList<Object> result = new LinkedList<Object>();
        int i = 0;
        while (i < arguments.length) {
            log.debug((Object)("args[" + i + "] = " + String.valueOf(arguments[i]) + "(" + (arguments[i] != null ? arguments[i].getClass().getName() : "null") + ")"));
            if (arguments[i] == null || arguments[i] instanceof String || arguments[i] instanceof Number) {
                result.add(arguments[i]);
            } else if (arguments[i] instanceof DTMNodeProxy) {
                result.add(((DTMNodeProxy)arguments[i]).getStringValue());
            } else if (arguments[i] instanceof Node) {
                log.debug((Object)("node type is " + ((Node)arguments[i]).getNodeType() + " content " + ((Node)arguments[i]).getTextContent()));
                result.add(((Node)arguments[i]).getNodeValue());
            } else if (arguments[i] instanceof NodeIterator) {
                Node n = ((NodeIterator)arguments[i]).nextNode();
                while (n != null) {
                    log.debug((Object)("iterated to node " + String.valueOf(n) + " type " + n.getNodeType() + " value " + n.getNodeValue() + " tc " + n.getTextContent() + " nn " + n.getNodeName() + " sv " + ((DTMNodeProxy)n).getStringValue()));
                    if (n instanceof DTMNodeProxy) {
                        result.add(((DTMNodeProxy)n).getStringValue());
                    } else {
                        result.add(n);
                    }
                    n = ((NodeIterator)arguments[i]).nextNode();
                }
            } else {
                throw new IllegalArgumentException("unable to convert argument " + String.valueOf(arguments[i]));
            }
            ++i;
        }
        return result.toArray(new Object[result.size()]);
    }

    public Object invokeMethod(String id, Object[] arguments) throws Exception {
        if (!PROCESSOR_METHODS.containsKey(id)) {
            throw new NullPointerException("unable to find method " + id);
        }
        TemplateProcessorMethod method = PROCESSOR_METHODS.get(id);
        arguments = this.convertArguments(arguments);
        log.debug((Object)("invoking " + id + " with " + arguments.length));
        Object result = method.exec(arguments);
        log.debug((Object)(id + " returned a " + String.valueOf(result)));
        if (result == null) {
            return null;
        }
        if (result.getClass().isArray() && Node.class.isAssignableFrom(result.getClass().getComponentType())) {
            log.debug((Object)("converting " + String.valueOf(result) + " to a node iterator"));
            final Node[] array = (Node[])result;
            return new NodeIterator(){
                private int index = 0;
                private boolean detached = false;

                @Override
                public void detach() {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"detaching NodeIterator");
                    }
                    this.detached = true;
                }

                @Override
                public boolean getExpandEntityReferences() {
                    return true;
                }

                @Override
                public int getWhatToShow() {
                    return -1;
                }

                @Override
                public Node getRoot() {
                    return array.length == 0 ? null : array[0].getOwnerDocument().getDocumentElement();
                }

                @Override
                public NodeFilter getFilter() {
                    return new NodeFilter(){

                        @Override
                        public short acceptNode(Node n) {
                            return 1;
                        }
                    };
                }

                @Override
                public Node nextNode() throws DOMException {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("NodeIterator.nextNode(" + this.index + ")"));
                    }
                    if (this.detached) {
                        throw new DOMException(11, null);
                    }
                    return this.index == array.length ? null : array[this.index++];
                }

                @Override
                public Node previousNode() throws DOMException {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("NodeIterator.previousNode(" + this.index + ")"));
                    }
                    if (this.detached) {
                        throw new DOMException(11, null);
                    }
                    return this.index == -1 ? null : array[this.index--];
                }
            };
        }
        if (result instanceof String || result instanceof Number || result instanceof Node) {
            log.debug((Object)("returning " + String.valueOf(result) + " as is"));
            return result;
        }
        throw new IllegalArgumentException("unable to convert " + result.getClass().getName());
    }
}

