/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.AbstractMTAsynchronouslyRefreshedCache;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authority.AuthorityBridgeDAO;
import org.alfresco.repo.security.authority.AuthorityBridgeLink;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.util.BridgeTable;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class AuthorityBridgeTableAsynchronouslyRefreshedCache
extends AbstractMTAsynchronouslyRefreshedCache<BridgeTable<String>>
implements InitializingBean {
    private AuthorityBridgeDAO authorityBridgeDAO;
    private RetryingTransactionHelper retryingTransactionHelper;
    private TenantAdminService tenantAdminService;
    private AuthorityDAO authorityDAO;
    private Log logger = LogFactory.getLog(this.getClass());

    public void setAuthorityDAO(AuthorityDAO authorityDAO) {
        this.authorityDAO = authorityDAO;
    }

    public void setAuthorityBridgeDAO(AuthorityBridgeDAO authorityBridgeDAO) {
        this.authorityBridgeDAO = authorityBridgeDAO;
    }

    public void setRetryingTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    @Override
    protected BridgeTable<String> buildCache(final String tenantId) {
        return (BridgeTable)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<BridgeTable<String>>(){

            public BridgeTable<String> doWork() throws Exception {
                return AuthorityBridgeTableAsynchronouslyRefreshedCache.this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<BridgeTable<String>>(){

                    @Override
                    public BridgeTable<String> execute() throws Throwable {
                        return AuthorityBridgeTableAsynchronouslyRefreshedCache.this.doBuildCache(tenantId);
                    }
                }, true, false);
            }
        }, (String)this.tenantAdminService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantId));
    }

    private BridgeTable<String> doBuildCache(String tenantId) {
        List<AuthorityBridgeLink> links = this.authorityBridgeDAO.getAuthorityBridgeLinks();
        BridgeTable bridgeTable = new BridgeTable();
        try {
            for (AuthorityBridgeLink link : links) {
                bridgeTable.addLink((Object)link.getParentName(), (Object)link.getChildName());
            }
        }
        catch (ConcurrentModificationException e) {
            this.checkCyclic(links);
            throw e;
        }
        return bridgeTable;
    }

    private void checkCyclic(List<AuthorityBridgeLink> links) {
        HashMap<String, Set<String>> parentsToChildren = new HashMap<String, Set<String>>();
        for (AuthorityBridgeLink link : links) {
            this.addToMap(parentsToChildren, link.getParentName(), link.getChildName());
        }
        HashMap<String, Set<String>> removed = new HashMap<String, Set<String>>();
        for (String parent : parentsToChildren.keySet()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Start checking from '" + parent + "'"));
            }
            HashSet<String> authorities = new HashSet<String>();
            authorities.add(parent);
            this.doCheck(parent, parentsToChildren, authorities, removed);
        }
        if (!removed.isEmpty()) {
            this.fixCyclic(removed);
            throw new AlfrescoRuntimeException("Cyclic links were detected and removed.");
        }
    }

    private void doCheck(String parent, Map<String, Set<String>> parentsToChildren, Set<String> authorities, Map<String, Set<String>> removed) {
        Set<String> children = parentsToChildren.get(parent);
        if (children != null) {
            for (String child : children) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Check link from '" + parent + "' to '" + child + "'"));
                }
                if (this.isRemoved(removed, parent, child)) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Link from '" + parent + "' to '" + child + "' has been already removed"));
                    continue;
                }
                if (!authorities.add(child)) {
                    this.addToMap(removed, parent, child);
                    continue;
                }
                this.doCheck(child, parentsToChildren, authorities, removed);
                authorities.remove(child);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Children of '" + parent + "' were processed"));
            }
        }
    }

    private boolean isRemoved(Map<String, Set<String>> removed, String parent, String child) {
        Set<String> remChildren = removed.get(parent);
        return remChildren != null && remChildren.contains(child);
    }

    private void addToMap(Map<String, Set<String>> map, String parent, String child) {
        Set<String> children = map.get(parent);
        if (children == null) {
            children = new HashSet<String>();
            children.add(child);
            map.put(parent, children);
        } else {
            children.add(child);
        }
    }

    private void fixCyclic(final Map<String, Set<String>> removed) {
        this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                for (String parentName : removed.keySet()) {
                    for (String childName : (Set)removed.get(parentName)) {
                        AuthorityBridgeTableAsynchronouslyRefreshedCache.this.authorityDAO.removeAuthority(parentName, childName, false);
                        AuthorityBridgeTableAsynchronouslyRefreshedCache.this.logger.error((Object)("Link from '" + parentName + "' to '" + childName + "' was removed to break cycle."));
                    }
                }
                return null;
            }
        }, false, true);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"authorityBridgeDAO", (Object)this.authorityBridgeDAO);
        PropertyCheck.mandatory((Object)this, (String)"retryingTransactionHelper", (Object)this.retryingTransactionHelper);
        PropertyCheck.mandatory((Object)this, (String)"authorityDAO", (Object)this.authorityDAO);
        super.afterPropertiesSet();
    }
}

