/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.links;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.query.CannedQueryFactory;
import org.alfresco.query.CannedQueryResults;
import org.alfresco.query.EmptyPagingResults;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.links.LinkInfoImpl;
import org.alfresco.repo.links.LinksModel;
import org.alfresco.repo.node.getchildren.GetChildrenAuditableCannedQuery;
import org.alfresco.repo.node.getchildren.GetChildrenAuditableCannedQueryFactory;
import org.alfresco.repo.query.NodeBackedEntity;
import org.alfresco.repo.search.LuceneUtils;
import org.alfresco.repo.site.SiteServiceImpl;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.links.LinkInfo;
import org.alfresco.service.cmr.links.LinksService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ISO9075;
import org.alfresco.util.Pair;
import org.alfresco.util.registry.NamedObjectRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LinksServiceImpl
implements LinksService {
    public static final String LINKS_COMPONENT = "links";
    protected static final String CANNED_QUERY_GET_CHILDREN = "linksGetChildrenCannedQueryFactory";
    private static Log logger = LogFactory.getLog(LinksServiceImpl.class);
    private NodeDAO nodeDAO;
    private NodeService nodeService;
    private SiteService siteService;
    private SearchService searchService;
    private ContentService contentService;
    private TaggingService taggingService;
    private NamespaceService namespaceService;
    private DictionaryService dictionaryService;
    private TransactionService transactionService;
    private NamedObjectRegistry<CannedQueryFactory<? extends Object>> cannedQueryRegistry;

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setCannedQueryRegistry(NamedObjectRegistry<CannedQueryFactory<? extends Object>> cannedQueryRegistry) {
        this.cannedQueryRegistry = cannedQueryRegistry;
    }

    protected NodeRef getSiteLinksContainer(String siteShortName, boolean create) {
        return SiteServiceImpl.getSiteContainer(siteShortName, LINKS_COMPONENT, create, this.siteService, this.transactionService, this.taggingService);
    }

    private LinkInfo buildLink(NodeRef nodeRef, NodeRef container, String name) {
        LinkInfoImpl link = new LinkInfoImpl(nodeRef, container, name);
        Map props = this.nodeService.getProperties(nodeRef);
        link.setCreator((String)props.get(ContentModel.PROP_CREATOR));
        link.setCreatedAt((Date)props.get(ContentModel.PROP_CREATED));
        link.setModifiedAt((Date)props.get(ContentModel.PROP_MODIFIED));
        link.setTitle((String)props.get(LinksModel.PROP_TITLE));
        link.setDescription((String)props.get(LinksModel.PROP_DESCRIPTION));
        link.setURL((String)props.get(LinksModel.PROP_URL));
        if (this.nodeService.hasAspect(nodeRef, LinksModel.ASPECT_INTERNAL_LINK)) {
            Boolean isInternal = (Boolean)DefaultTypeConverter.INSTANCE.convert(Boolean.class, props.get(LinksModel.PROP_IS_INTERNAL));
            link.setInternal(isInternal);
        } else {
            link.setInternal(false);
        }
        link.setTags(this.taggingService.getTags(nodeRef));
        return link;
    }

    @Override
    public LinkInfo getLink(String siteShortName, String linkName) {
        NodeRef container = this.getSiteLinksContainer(siteShortName, false);
        if (container == null) {
            return null;
        }
        NodeRef link = this.nodeService.getChildByName(container, ContentModel.ASSOC_CONTAINS, linkName);
        if (link != null) {
            return this.buildLink(link, container, linkName);
        }
        return null;
    }

    @Override
    public LinkInfo createLink(String siteShortName, String title, String description, String url, boolean internal) {
        NodeRef container = this.getSiteLinksContainer(siteShortName, true);
        HashMap<QName, Object> props = new HashMap<QName, Object>();
        props.put(LinksModel.PROP_TITLE, title);
        props.put(LinksModel.PROP_DESCRIPTION, description);
        props.put(LinksModel.PROP_URL, url);
        if (internal) {
            props.put(LinksModel.PROP_IS_INTERNAL, "true");
        }
        String name = "link-" + new Date().getTime() + "-" + Math.round(Math.random() * 10000.0);
        props.put(ContentModel.PROP_NAME, name);
        NodeRef nodeRef = this.nodeService.createNode(container, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), LinksModel.TYPE_LINK, props).getChildRef();
        ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        writer.setEncoding("UTF-8");
        writer.putContent(url);
        return this.buildLink(nodeRef, container, name);
    }

    @Override
    public LinkInfo updateLink(LinkInfo link) {
        if (link.getNodeRef() == null) {
            throw new IllegalArgumentException("Can't update a link that was never persisted, call create instead");
        }
        NodeRef nodeRef = link.getNodeRef();
        this.nodeService.setProperty(nodeRef, LinksModel.PROP_TITLE, (Serializable)((Object)link.getTitle()));
        this.nodeService.setProperty(nodeRef, LinksModel.PROP_DESCRIPTION, (Serializable)((Object)link.getDescription()));
        this.nodeService.setProperty(nodeRef, LinksModel.PROP_URL, (Serializable)((Object)link.getURL()));
        if (link.isInternal()) {
            if (!this.nodeService.hasAspect(nodeRef, LinksModel.ASPECT_INTERNAL_LINK)) {
                HashMap<QName, String> props = new HashMap<QName, String>();
                props.put(LinksModel.PROP_IS_INTERNAL, "true");
                this.nodeService.addAspect(nodeRef, LinksModel.ASPECT_INTERNAL_LINK, props);
            }
        } else if (this.nodeService.hasAspect(nodeRef, LinksModel.ASPECT_INTERNAL_LINK)) {
            this.nodeService.removeAspect(nodeRef, LinksModel.ASPECT_INTERNAL_LINK);
        }
        ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        writer.setEncoding("UTF-8");
        writer.putContent(link.getURL());
        this.taggingService.setTags(nodeRef, link.getTags());
        return link;
    }

    @Override
    public void deleteLink(LinkInfo link) {
        if (link.getNodeRef() == null) {
            throw new IllegalArgumentException("Can't delete a link entry that was never persisted");
        }
        this.nodeService.deleteNode(link.getNodeRef());
    }

    @Override
    public PagingResults<LinkInfo> listLinks(String siteShortName, PagingRequest paging) {
        return this.listLinks(siteShortName, null, null, null, paging);
    }

    @Override
    public PagingResults<LinkInfo> listLinks(String siteShortName, String user, PagingRequest paging) {
        return this.listLinks(siteShortName, user, null, null, paging);
    }

    @Override
    public PagingResults<LinkInfo> listLinks(String siteShortName, Date from, Date to, PagingRequest paging) {
        return this.listLinks(siteShortName, null, from, to, paging);
    }

    private PagingResults<LinkInfo> listLinks(String siteShortName, String user, Date from, Date to, PagingRequest paging) {
        NodeRef container = this.getSiteLinksContainer(siteShortName, false);
        if (container == null) {
            return new EmptyPagingResults();
        }
        GetChildrenAuditableCannedQueryFactory getChildrenCannedQueryFactory = (GetChildrenAuditableCannedQueryFactory)((Object)this.cannedQueryRegistry.getNamedObject(CANNED_QUERY_GET_CHILDREN));
        GetChildrenAuditableCannedQuery cq = (GetChildrenAuditableCannedQuery)getChildrenCannedQueryFactory.getCannedQuery(container, LinksModel.TYPE_LINK, user, from, to, null, null, null, getChildrenCannedQueryFactory.createDateDescendingCQSortDetails(), paging);
        CannedQueryResults results = cq.execute();
        return this.wrap((PagingResults<NodeBackedEntity>)results, container);
    }

    @Override
    public PagingResults<LinkInfo> findLinks(String siteShortName, String user, Date from, Date to, String tag, PagingRequest paging) {
        NodeRef container = this.getSiteLinksContainer(siteShortName, false);
        if (container == null) {
            return new EmptyPagingResults();
        }
        StringBuilder luceneQuery = new StringBuilder();
        luceneQuery.append(" +TYPE:\"" + String.valueOf(LinksModel.TYPE_LINK) + "\"");
        luceneQuery.append(" +PATH:\"" + this.nodeService.getPath(container).toPrefixString((NamespacePrefixResolver)this.namespaceService) + "/*\"");
        if (user != null) {
            luceneQuery.append(" +@cm\\:creator:\"" + user + "\"");
        }
        if (from != null && to != null) {
            luceneQuery.append(LuceneUtils.createDateRangeQuery(from, to, ContentModel.PROP_CREATED, this.dictionaryService, this.namespaceService));
        }
        if (tag != null) {
            luceneQuery.append(" +PATH:\"/cm:taggable/cm:" + ISO9075.encode((String)tag) + "/member\"");
        }
        String sortOn = "@{http://www.alfresco.org/model/content/1.0}created";
        SearchParameters sp = new SearchParameters();
        sp.addStore(container.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery(luceneQuery.toString());
        sp.addSort(sortOn, false);
        if (paging.getSkipCount() > 0) {
            sp.setSkipCount(paging.getSkipCount());
        }
        PagingResults<LinkInfo> pagedResults = new PagingResults<LinkInfo>();
        try (ResultSet results = null;){
            results = this.searchService.query(sp);
            pagedResults = this.wrap(results, container, paging);
        }
        return pagedResults;
    }

    private PagingResults<LinkInfo> wrap(final ResultSet finalLuceneResults, NodeRef container, final PagingRequest paging) {
        final ArrayList<LinkInfo> links = new ArrayList<LinkInfo>();
        int cnt = 1;
        for (ResultSetRow row : finalLuceneResults) {
            LinkInfo link = this.buildLink(row.getNodeRef(), container, row.getQName().getLocalName());
            links.add(link);
            if (paging.getMaxItems() > 0 && ++cnt > paging.getMaxItems()) break;
        }
        return new PagingResults<LinkInfo>(){

            public boolean hasMoreItems() {
                try {
                    return finalLuceneResults.hasMore();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    return false;
                }
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                int skipCount = 0;
                int itemsRemainingAfterThisPage = 0;
                try {
                    skipCount = finalLuceneResults.getStart();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    skipCount = paging.getSkipCount();
                }
                try {
                    itemsRemainingAfterThisPage = finalLuceneResults.length();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
                int totalItemsInUnpagedResultSet = skipCount + itemsRemainingAfterThisPage;
                return new Pair((Object)totalItemsInUnpagedResultSet, (Object)totalItemsInUnpagedResultSet);
            }

            public List<LinkInfo> getPage() {
                return links;
            }

            public String getQueryExecutionId() {
                return null;
            }
        };
    }

    private PagingResults<LinkInfo> wrap(final PagingResults<NodeBackedEntity> results, final NodeRef container) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (NodeBackedEntity node : results.getPage()) {
            ids.add(node.getId());
        }
        this.nodeDAO.cacheNodesById(ids);
        return new PagingResults<LinkInfo>(){

            public String getQueryExecutionId() {
                return results.getQueryExecutionId();
            }

            public List<LinkInfo> getPage() {
                ArrayList<LinkInfo> links = new ArrayList<LinkInfo>();
                for (NodeBackedEntity node : results.getPage()) {
                    NodeRef nodeRef = node.getNodeRef();
                    String name = node.getName();
                    links.add(LinksServiceImpl.this.buildLink(nodeRef, container, name));
                }
                return links;
            }

            public boolean hasMoreItems() {
                return results.hasMoreItems();
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return results.getTotalResultCount();
            }
        };
    }
}

