/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.dialect;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.repo.domain.dialect.DialectFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class DialectFactoryBean
implements FactoryBean<Dialect> {
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Dialect getObject() throws SQLException {
        Dialect dialect;
        Connection con = null;
        try {
            Dialect dialect2;
            con = DataSourceUtils.getConnection((DataSource)this.dataSource);
            con.setAutoCommit(true);
            DatabaseMetaData meta = con.getMetaData();
            dialect = dialect2 = DialectFactory.buildDialect(meta.getDatabaseProductName(), meta.getDatabaseMajorVersion(), meta.getDriverName());
        }
        catch (Throwable throwable) {
            try {
                con.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            con.close();
        }
        catch (Exception exception) {}
        return dialect;
    }

    public Class<?> getObjectType() {
        return Dialect.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

