/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.descriptor;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.alfresco.repo.descriptor.DescriptorDAO;
import org.alfresco.repo.descriptor.DescriptorServiceImpl;
import org.alfresco.service.cmr.admin.RepoUsage;
import org.alfresco.service.descriptor.Descriptor;
import org.springframework.core.io.Resource;

public class ServerDescriptorDAOImpl
implements DescriptorDAO {
    private String repositoryName;
    protected Properties serverProperties;

    public void setRepositoryName(String repositoryName) throws IOException {
        this.repositoryName = repositoryName;
    }

    public void setResource(Resource[] locations) throws IOException {
        this.serverProperties = new Properties();
        int i = 0;
        while (i < locations.length) {
            InputStream is = locations[i].getInputStream();
            try {
                this.serverProperties.load(is);
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            ++i;
        }
    }

    @Override
    public Descriptor getDescriptor() {
        return new ServerDescriptor();
    }

    @Override
    public byte[] getLicenseKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Descriptor updateDescriptor(Descriptor serverDescriptor, RepoUsage.LicenseMode licenseMode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateLicenseKey(byte[] key) {
        throw new UnsupportedOperationException();
    }

    private class ServerDescriptor
    extends DescriptorServiceImpl.BaseDescriptor {
        private ServerDescriptor() {
        }

        @Override
        public String getId() {
            return "Unknown";
        }

        @Override
        public String getName() {
            return ServerDescriptorDAOImpl.this.repositoryName == null ? "<Unknown>" : ServerDescriptorDAOImpl.this.repositoryName;
        }

        @Override
        public String getVersionMajor() {
            return ServerDescriptorDAOImpl.this.serverProperties.getProperty("version.major");
        }

        @Override
        public String getVersionMinor() {
            return ServerDescriptorDAOImpl.this.serverProperties.getProperty("version.minor");
        }

        @Override
        public String getVersionRevision() {
            return ServerDescriptorDAOImpl.this.serverProperties.getProperty("version.revision");
        }

        @Override
        public String getVersionLabel() {
            return ServerDescriptorDAOImpl.this.serverProperties.getProperty("version.label");
        }

        @Override
        public String getVersionBuild() {
            return ServerDescriptorDAOImpl.this.serverProperties.getProperty("version.build");
        }

        @Override
        public String getEdition() {
            return ServerDescriptorDAOImpl.this.serverProperties.getProperty("version.edition");
        }

        @Override
        public int getSchema() {
            return this.getSchema(ServerDescriptorDAOImpl.this.serverProperties.getProperty("version.schema"));
        }

        @Override
        public String[] getDescriptorKeys() {
            String[] keys = new String[ServerDescriptorDAOImpl.this.serverProperties.size()];
            ServerDescriptorDAOImpl.this.serverProperties.keySet().toArray(keys);
            return keys;
        }

        @Override
        public String getDescriptor(String key) {
            return ServerDescriptorDAOImpl.this.serverProperties.getProperty(key, "");
        }

        @Override
        public RepoUsage.LicenseMode getLicenseMode() {
            return RepoUsage.LicenseMode.UNKNOWN;
        }
    }
}

