/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.admin.patch.PatchExecuter;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteServiceImpl;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class RenameSiteAuthorityDisplayName
extends AbstractPatch {
    private static final String SUCCESS_MSG = "patch.renameSiteAuthorityDisplayName.result";
    private static final int BATCH_THREADS = 4;
    private static final int BATCH_SIZE = 250;
    private SiteService siteService;
    private PermissionService permissionService;
    private AuthorityService authorityService;
    private RuleService ruleService;
    private static Log progress_logger = LogFactory.getLog(PatchExecuter.class);

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    @Override
    protected String applyInternal() throws Exception {
        if (AuthenticationUtil.isRunAsUserTheSystemUser() || !AuthenticationUtil.isMtEnabled()) {
            List<SiteInfo> sites = this.siteService.listSites(null, null);
            this.renameDispayNames(sites);
        }
        return I18NUtil.getMessage((String)SUCCESS_MSG);
    }

    private void renameDispayNames(final List<SiteInfo> siteInfos) {
        final String tenantDomain = this.tenantAdminService.getCurrentUserDomain();
        final ListIterator<SiteInfo> pathItr = siteInfos.listIterator();
        BatchProcessWorkProvider<SiteInfo> siteWorkProvider = new BatchProcessWorkProvider<SiteInfo>(){

            @Override
            public int getTotalEstimatedWorkSize() {
                return siteInfos.size();
            }

            @Override
            public long getTotalEstimatedWorkSizeLong() {
                return siteInfos.size();
            }

            @Override
            public Collection<SiteInfo> getNextWork() {
                int batchCount = 0;
                ArrayList<SiteInfo> nodes = new ArrayList<SiteInfo>(250);
                while (pathItr.hasNext() && batchCount++ != 250) {
                    nodes.add((SiteInfo)pathItr.next());
                }
                return nodes;
            }
        };
        BatchProcessor<SiteInfo> siteBatchProcessor = new BatchProcessor<SiteInfo>("RenameSiteAuthorityDisplayName", this.transactionHelper, siteWorkProvider, 4, 250, this.applicationEventPublisher, progress_logger, 2500);
        BatchProcessor.BatchProcessWorker<SiteInfo> worker = new BatchProcessor.BatchProcessWorker<SiteInfo>(){

            @Override
            public String getIdentifier(SiteInfo entry) {
                return entry.getShortName();
            }

            @Override
            public void beforeProcess() throws Throwable {
                RenameSiteAuthorityDisplayName.this.ruleService.disableRules();
                String systemUser = AuthenticationUtil.getSystemUserName();
                systemUser = RenameSiteAuthorityDisplayName.this.tenantAdminService.getDomainUser(systemUser, tenantDomain);
                AuthenticationUtil.setRunAsUser((String)systemUser);
            }

            @Override
            public void afterProcess() throws Throwable {
                RenameSiteAuthorityDisplayName.this.ruleService.enableRules();
                AuthenticationUtil.clearCurrentSecurityContext();
            }

            @Override
            public void process(SiteInfo siteInfo) throws Throwable {
                Set sitePermissions = RenameSiteAuthorityDisplayName.this.permissionService.getAllSetPermissions(siteInfo.getNodeRef());
                for (AccessPermission sitePermission : sitePermissions) {
                    if (sitePermission.getAuthorityType() != AuthorityType.GROUP) continue;
                    String authorityName = sitePermission.getAuthority();
                    String currDisplayName = RenameSiteAuthorityDisplayName.this.authorityService.getAuthorityDisplayName(authorityName);
                    String necessaryName = ((SiteServiceImpl)RenameSiteAuthorityDisplayName.this.siteService).getSiteRoleGroup(siteInfo.getShortName(), sitePermission.getPermission(), false);
                    String alternativeName = ((SiteServiceImpl)RenameSiteAuthorityDisplayName.this.siteService).getSiteRoleGroup(siteInfo.getShortName(), sitePermission.getPermission(), true);
                    if (necessaryName.equalsIgnoreCase(currDisplayName) && alternativeName.equalsIgnoreCase(currDisplayName)) continue;
                    RenameSiteAuthorityDisplayName.this.authorityService.setAuthorityDisplayName(authorityName, necessaryName);
                }
            }
        };
        siteBatchProcessor.process(worker, true);
    }
}

