/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.List;
import java.util.Map;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.domain.mimetype.MimetypeDAO;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.util.Pair;
import org.springframework.extensions.surf.util.I18NUtil;

public class GenericMimetypeRenamePatch
extends AbstractPatch {
    private static final String MSG_START = "patch.genericMimetypeUpdate.start";
    private static final String MSG_UPDATED = "patch.genericMimetypeUpdate.updated";
    private static final String MSG_INDEXED = "patch.genericMimetypeUpdate.indexed";
    private static final String MSG_DONE = "patch.genericMimetypeUpdate.done";
    private static final String MSG_DONE_REINDEX = "patch.genericMimetypeUpdate.doneReindex";
    private MimetypeDAO mimetypeDAO;
    private PatchDAO patchDAO;
    private NodeDAO nodeDAO;
    private RetryingTransactionHelper retryingTransactionHelper;
    private static long BATCH_SIZE = 100000L;
    private Map<String, String> mimetypeMappings;
    private boolean reindex;

    public void setMimetypeDAO(MimetypeDAO mimetypeDAO) {
        this.mimetypeDAO = mimetypeDAO;
    }

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    public void setMimetypeMappings(Map<String, String> mimetypeMappings) {
        this.mimetypeMappings = mimetypeMappings;
    }

    public void setReindex(boolean reindex) {
        this.reindex = reindex;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setRetryingTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    @Override
    protected void checkProperties() {
        super.checkProperties();
        this.checkPropertyNotNull(this.mimetypeDAO, "mimetypeDAO");
        this.checkPropertyNotNull(this.patchDAO, "patchDAO");
        this.checkPropertyNotNull(this.mimetypeMappings, "mimetypeMappings");
        this.checkPropertyNotNull(this.nodeDAO, "nodeDAO");
        this.checkPropertyNotNull(this.retryingTransactionHelper, "retryingTransactionHelper");
    }

    @Override
    protected String applyInternal() throws Exception {
        StringBuilder result = new StringBuilder(I18NUtil.getMessage((String)MSG_START));
        Long maxNodeId = this.patchDAO.getMaxAdmNodeID();
        for (Map.Entry<String, String> element : this.mimetypeMappings.entrySet()) {
            String oldMimetype = element.getKey();
            String newMimetype = element.getValue();
            Pair<Long, String> oldMimetypePair = this.mimetypeDAO.getMimetype(oldMimetype);
            if (oldMimetypePair == null) continue;
            if (this.reindex) {
                long count = 0L;
                Long i = 0L;
                while (i < maxNodeId) {
                    Work work = new Work((Long)oldMimetypePair.getFirst(), i);
                    count += (long)this.retryingTransactionHelper.doInTransaction(work, false, true).intValue();
                    i = i + BATCH_SIZE;
                }
                result.append(I18NUtil.getMessage((String)MSG_INDEXED, (Object[])new Object[]{count, "(All stores)"}));
            }
            Pair<Long, String> newMimetypePair = this.mimetypeDAO.getMimetype(newMimetype);
            int updateCount = 0;
            if (newMimetypePair == null) {
                updateCount = this.mimetypeDAO.updateMimetype(oldMimetype, newMimetype);
            } else {
                Long oldMimetypeId = (Long)oldMimetypePair.getFirst();
                Long newMimetypeId = (Long)this.mimetypeDAO.getOrCreateMimetype(newMimetype).getFirst();
                updateCount = this.patchDAO.updateContentMimetypeIds(oldMimetypeId, newMimetypeId);
            }
            result.append(I18NUtil.getMessage((String)MSG_UPDATED, (Object[])new Object[]{updateCount, oldMimetype, newMimetype}));
        }
        if (this.reindex) {
            result.append(I18NUtil.getMessage((String)MSG_DONE));
        } else {
            result.append(I18NUtil.getMessage((String)MSG_DONE_REINDEX));
        }
        return result.toString();
    }

    private class Work
    implements RetryingTransactionHelper.RetryingTransactionCallback<Integer> {
        long mimetypeId;
        long lower;

        Work(long mimetypeId, long lower) {
            this.mimetypeId = mimetypeId;
            this.lower = lower;
        }

        @Override
        public Integer execute() throws Throwable {
            List<Long> nodeIds = GenericMimetypeRenamePatch.this.patchDAO.getNodesByContentPropertyMimetypeId(this.mimetypeId, this.lower, this.lower + BATCH_SIZE);
            GenericMimetypeRenamePatch.this.nodeDAO.touchNodes(GenericMimetypeRenamePatch.this.nodeDAO.getCurrentTransactionId(true), nodeIds);
            return nodeIds.size();
        }
    }
}

