/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.action.CommonResourceAbstractBase;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.RuntimeActionService;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.action.ParameterizedItem;
import org.alfresco.service.cmr.action.ParameterizedItemDefinition;
import org.alfresco.service.cmr.rule.RuleServiceException;
import org.springframework.extensions.surf.util.I18NUtil;

public abstract class ParameterizedItemAbstractBase
extends CommonResourceAbstractBase {
    private static final String ERR_MAND_PROP = "A value for the mandatory parameter {0} has not been set on the rule item {1}";
    private static final String TITLE = "title";
    private static final String DESCRIPTION = "description";
    protected static final String DISPLAY_LABEL = "display-label";
    protected boolean adhocPropertiesAllowed = false;
    protected RuntimeActionService runtimeActionService;
    private Set<Locale> locales = new HashSet<Locale>();

    public String toString() {
        StringBuilder sb = new StringBuilder(60);
        sb.append("ParameterizedItem").append("[ title='").append(this.getTitleKey()).append("'").append(", description='").append(this.getDescriptionKey()).append("'").append("]");
        return sb.toString();
    }

    public void setLocales(Set<Locale> locales) {
        this.locales = locales;
    }

    protected List<ParameterDefinition> getParameterDefintions() {
        ArrayList<ParameterDefinition> result = new ArrayList<ParameterDefinition>();
        this.addParameterDefinitions(result);
        return result;
    }

    protected abstract void addParameterDefinitions(List<ParameterDefinition> var1);

    protected Map<Locale, List<ParameterDefinition>> getLocalizedParameterDefinitions() {
        LinkedList<ParameterDefinition> paramList = new LinkedList<ParameterDefinition>();
        this.addParameterDefinitions(paramList);
        HashMap<Locale, List<ParameterDefinition>> result = new HashMap<Locale, List<ParameterDefinition>>();
        result.put(Locale.ROOT, paramList);
        for (Locale locale : this.locales) {
            LinkedList<ParameterDefinitionImpl> definitions = new LinkedList<ParameterDefinitionImpl>();
            result.put(locale, definitions);
            for (ParameterDefinition definition : paramList) {
                String paramDisplayLabel = this.getParamDisplayLabel(definition.getName(), locale);
                definitions.add(new ParameterDefinitionImpl(definition.getName(), definition.getType(), definition.isMandatory(), paramDisplayLabel, definition.isMultiValued(), definition.getParameterConstraintName()));
            }
        }
        return result;
    }

    public void setRuntimeActionService(RuntimeActionService runtimeActionService) {
        this.runtimeActionService = runtimeActionService;
    }

    protected String getTitleKey() {
        return this.name + ".title";
    }

    protected String getDescriptionKey() {
        return this.name + ".description";
    }

    public void setAdhocPropertiesAllowed(boolean allowed) {
        this.adhocPropertiesAllowed = allowed;
    }

    protected boolean getAdhocPropertiesAllowed() {
        return this.adhocPropertiesAllowed;
    }

    protected String getParamDisplayLabel(String paramName) {
        return I18NUtil.getMessage((String)(this.name + "." + paramName + ".display-label"));
    }

    protected String getParamDisplayLabel(String paramName, Locale locale) {
        return I18NUtil.getMessage((String)(this.name + "." + paramName + ".display-label"), (Locale)locale);
    }

    protected void checkMandatoryProperties(ParameterizedItem ruleItem, ParameterizedItemDefinition ruleItemDefinition) {
        List<ParameterDefinition> definitions = ruleItemDefinition.getParameterDefinitions();
        if (definitions != null && definitions.size() > 0) {
            for (ParameterDefinition definition : definitions) {
                if (!definition.isMandatory() || ruleItem.getParameterValue(definition.getName()) != null) continue;
                throw new RuleServiceException(MessageFormat.format(ERR_MAND_PROP, definition.getName(), ruleItemDefinition.getName()));
            }
        }
    }
}

