/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice.user;

import java.util.Optional;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.repo.security.authentication.identityservice.user.AccessTokenToDecodedTokenUserMapper;
import org.alfresco.repo.security.authentication.identityservice.user.DecodedTokenUser;
import org.alfresco.repo.security.authentication.identityservice.user.UserInfoAttrMapping;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class AccessTokenToDecodedTokenUserMapperUnitTest {
    @Mock
    private IdentityServiceFacade.DecodedAccessToken decodedAccessToken;
    private AccessTokenToDecodedTokenUserMapper tokenToDecodedTokenUserMapper;
    public static final String USERNAME_CLAIM = "nickname";
    public static final String EMAIL_CLAIM = "email";
    public static final String FIRST_NAME_CLAIM = "given_name";
    public static final String LAST_NAME_CLAIM = "family_name";

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        UserInfoAttrMapping userInfoAttrMapping = new UserInfoAttrMapping(USERNAME_CLAIM, FIRST_NAME_CLAIM, LAST_NAME_CLAIM, EMAIL_CLAIM);
        this.tokenToDecodedTokenUserMapper = new AccessTokenToDecodedTokenUserMapper(userInfoAttrMapping);
    }

    @Test
    public void shouldMapToDecodedTokenUserWithAllFieldsPopulated() {
        Mockito.when((Object)this.decodedAccessToken.getClaim(USERNAME_CLAIM)).thenReturn((Object)"johny123");
        Mockito.when((Object)this.decodedAccessToken.getClaim(FIRST_NAME_CLAIM)).thenReturn((Object)"John");
        Mockito.when((Object)this.decodedAccessToken.getClaim(LAST_NAME_CLAIM)).thenReturn((Object)"Doe");
        Mockito.when((Object)this.decodedAccessToken.getClaim(EMAIL_CLAIM)).thenReturn((Object)"johny123@email.com");
        Optional result = this.tokenToDecodedTokenUserMapper.toDecodedTokenUser(this.decodedAccessToken);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"johny123", (Object)((DecodedTokenUser)result.get()).username());
        Assert.assertEquals((Object)"John", (Object)((DecodedTokenUser)result.get()).firstName());
        Assert.assertEquals((Object)"Doe", (Object)((DecodedTokenUser)result.get()).lastName());
        Assert.assertEquals((Object)"johny123@email.com", (Object)((DecodedTokenUser)result.get()).email());
    }

    @Test
    public void shouldMapToDecodedTokenUserWithSomeFieldsEmpty() {
        Mockito.when((Object)this.decodedAccessToken.getClaim(USERNAME_CLAIM)).thenReturn((Object)"johny123");
        Mockito.when((Object)this.decodedAccessToken.getClaim(FIRST_NAME_CLAIM)).thenReturn((Object)"");
        Mockito.when((Object)this.decodedAccessToken.getClaim(LAST_NAME_CLAIM)).thenReturn((Object)"Doe");
        Mockito.when((Object)this.decodedAccessToken.getClaim(EMAIL_CLAIM)).thenReturn((Object)"");
        Optional result = this.tokenToDecodedTokenUserMapper.toDecodedTokenUser(this.decodedAccessToken);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"johny123", (Object)((DecodedTokenUser)result.get()).username());
        Assert.assertEquals((Object)"", (Object)((DecodedTokenUser)result.get()).firstName());
        Assert.assertEquals((Object)"Doe", (Object)((DecodedTokenUser)result.get()).lastName());
        Assert.assertEquals((Object)"", (Object)((DecodedTokenUser)result.get()).email());
    }

    @Test
    public void shouldReturnEmptyOptionalForNullUsername() {
        Mockito.when((Object)this.decodedAccessToken.getClaim(USERNAME_CLAIM)).thenReturn(null);
        Mockito.when((Object)this.decodedAccessToken.getClaim(FIRST_NAME_CLAIM)).thenReturn((Object)"John");
        Mockito.when((Object)this.decodedAccessToken.getClaim(LAST_NAME_CLAIM)).thenReturn((Object)"Doe");
        Mockito.when((Object)this.decodedAccessToken.getClaim(EMAIL_CLAIM)).thenReturn((Object)"johny123@email.com");
        Optional result = this.tokenToDecodedTokenUserMapper.toDecodedTokenUser(this.decodedAccessToken);
        Assert.assertFalse((boolean)result.isPresent());
    }
}

