/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.model.AbstractDbObject;
import org.alfresco.util.schemacomp.model.Column;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.ForeignKey;
import org.alfresco.util.schemacomp.model.Index;
import org.alfresco.util.schemacomp.model.PrimaryKey;
import org.alfresco.util.schemacomp.model.Schema;

public class Table
extends AbstractDbObject {
    private final List<Column> columns = new ArrayList<Column>();
    private PrimaryKey primaryKey;
    private final List<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
    private final List<Index> indexes = new ArrayList<Index>();

    public Table(String name) {
        super(null, name);
    }

    public Table(String name, Collection<Column> columns, PrimaryKey primaryKey, Collection<ForeignKey> foreignKeys, Collection<Index> indexes) {
        this(null, name, columns, primaryKey, foreignKeys, indexes);
    }

    public Table(Schema parentSchema, String name, Collection<Column> columns, PrimaryKey primaryKey, Collection<ForeignKey> foreignKeys, Collection<Index> indexes) {
        super(parentSchema, name);
        if (columns != null) {
            this.setColumns(columns);
        }
        primaryKey.setParent(this);
        this.primaryKey = primaryKey;
        if (foreignKeys != null) {
            this.setForeignKeys(foreignKeys);
        }
        if (indexes != null) {
            this.setIndexes(indexes);
        }
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(Collection<Column> columns) {
        this.columns.clear();
        this.columns.addAll(columns);
        for (Column column : columns) {
            column.setParent(this);
        }
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public boolean hasPrimaryKey() {
        return this.primaryKey != null;
    }

    public void setPrimaryKey(PrimaryKey primaryKey) {
        primaryKey.setParent(this);
        this.primaryKey = primaryKey;
    }

    public List<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public void setForeignKeys(Collection<ForeignKey> foreignKeys) {
        this.foreignKeys.clear();
        this.foreignKeys.addAll(foreignKeys);
        for (ForeignKey fk : foreignKeys) {
            fk.setParent(this);
        }
    }

    public List<Index> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(Collection<Index> indexes) {
        this.indexes.clear();
        this.indexes.addAll(indexes);
        for (Index index : indexes) {
            index.setParent(this);
        }
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.columns == null ? 0 : this.columns.hashCode());
        result = 31 * result + (this.foreignKeys == null ? 0 : this.foreignKeys.hashCode());
        result = 31 * result + (this.indexes == null ? 0 : this.indexes.hashCode());
        result = 31 * result + (this.primaryKey == null ? 0 : this.primaryKey.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Table other = (Table)obj;
        if (this.columns == null ? other.columns != null : !this.columns.equals(other.columns)) {
            return false;
        }
        if (this.foreignKeys == null ? other.foreignKeys != null : !this.foreignKeys.equals(other.foreignKeys)) {
            return false;
        }
        if (this.indexes == null ? other.indexes != null : !this.indexes.equals(other.indexes)) {
            return false;
        }
        return !(this.primaryKey == null ? other.primaryKey != null : !this.primaryKey.equals(other.primaryKey));
    }

    @Override
    protected void doDiff(DbObject other, DiffContext ctx) {
        Table rightTable = (Table)other;
        this.comparisonUtils.compareCollections(this.columns, rightTable.columns, ctx);
        this.primaryKey.diff(rightTable.primaryKey, ctx);
        this.comparisonUtils.compareCollections(this.foreignKeys, rightTable.foreignKeys, ctx);
        this.comparisonUtils.compareCollections(this.indexes, rightTable.indexes, ctx);
    }

    private List<DbObject> getChildren() {
        ArrayList<DbObject> children = new ArrayList<DbObject>();
        children.addAll(this.columns);
        if (this.primaryKey != null) {
            children.add(this.primaryKey);
        }
        children.addAll(this.foreignKeys);
        children.addAll(this.indexes);
        return children;
    }

    @Override
    public void accept(DbObjectVisitor visitor) {
        visitor.visit(this);
        for (DbObject child : this.getChildren()) {
            child.accept(visitor);
        }
    }
}

