/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.model;

import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.model.AbstractDbObject;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.Table;

public class ForeignKey
extends AbstractDbObject {
    private String localColumn;
    private String targetTable;
    private String targetColumn;

    public ForeignKey(String name) {
        super(null, name);
    }

    public ForeignKey(Table table, String fkName, String localColumn, String targetTable, String targetColumn) {
        super(table, fkName);
        this.localColumn = localColumn;
        this.targetTable = targetTable;
        this.targetColumn = targetColumn;
    }

    public String getLocalColumn() {
        return this.localColumn;
    }

    public void setLocalColumn(String localColumn) {
        this.localColumn = localColumn;
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public void setTargetTable(String targetTable) {
        this.targetTable = targetTable;
    }

    public String getTargetColumn() {
        return this.targetColumn;
    }

    public void setTargetColumn(String targetColumn) {
        this.targetColumn = targetColumn;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.localColumn == null ? 0 : this.localColumn.hashCode());
        result = 31 * result + (this.targetColumn == null ? 0 : this.targetColumn.hashCode());
        result = 31 * result + (this.targetTable == null ? 0 : this.targetTable.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ForeignKey other = (ForeignKey)obj;
        if (this.localColumn == null ? other.localColumn != null : !this.localColumn.equals(other.localColumn)) {
            return false;
        }
        if (this.targetColumn == null ? other.targetColumn != null : !this.targetColumn.equals(other.targetColumn)) {
            return false;
        }
        return !(this.targetTable == null ? other.targetTable != null : !this.targetTable.equals(other.targetTable));
    }

    @Override
    protected void doDiff(DbObject right, DiffContext ctx) {
        ForeignKey thatFK = (ForeignKey)right;
        this.comparisonUtils.compareSimple(new DbProperty(this, "localColumn"), new DbProperty(thatFK, "localColumn"), ctx);
        this.comparisonUtils.compareSimple(new DbProperty(this, "targetTable"), new DbProperty(thatFK, "targetTable"), ctx);
        this.comparisonUtils.compareSimple(new DbProperty(this, "targetColumn"), new DbProperty(thatFK, "targetColumn"), ctx);
    }

    @Override
    public void accept(DbObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String getTypeName() {
        return "foreign key";
    }

    @Override
    public boolean sameAs(DbObject other) {
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        if (this.getParent() != null && this.getParent().sameAs(other.getParent())) {
            ForeignKey otherFK = (ForeignKey)other;
            if (!this.getLocalColumn().equals(otherFK.getLocalColumn())) {
                return false;
            }
            if (!this.getTargetTable().equalsIgnoreCase(otherFK.getTargetTable())) {
                return false;
            }
            return this.getTargetColumn().equals(otherFK.getTargetColumn());
        }
        return false;
    }
}

