/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.config;

import java.util.List;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.util.PropertyCheck;
import org.springframework.extensions.surf.util.ParameterCheck;

public class RepositoryPathConfigBean {
    private StoreRef store;
    private String rootPath;

    public StoreRef getStoreRef() {
        return this.store;
    }

    public String getStore() {
        return this.store == null ? null : this.store.toString();
    }

    public void setStore(String storeRef) {
        PropertyCheck.mandatory((Object)this, (String)"store", (Object)storeRef);
        this.store = new StoreRef(storeRef);
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String path) {
        PropertyCheck.mandatory((Object)this, (String)"path", (Object)path);
        ParameterCheck.mandatoryString((String)"path", (String)path);
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Propety 'path' must start with '/' - it is a path relative to the store root.");
        }
        this.rootPath = path;
    }

    public NodeRef resolveNodePath(NamespaceService namespaceService, NodeService nodeService, SearchService searchService) {
        NodeRef rootNodeRef = nodeService.getRootNode(this.store);
        List nodeRefs = searchService.selectNodes(rootNodeRef, this.rootPath, null, (NamespacePrefixResolver)namespaceService, true);
        if (nodeRefs.size() == 0) {
            return null;
        }
        return (NodeRef)nodeRefs.get(0);
    }
}

