/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.util.SerializationUtils;

public class ValueProtectingMap<K extends Serializable, V extends Serializable>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = -9073485393875357605L;
    public static final Set<Class<?>> DEFAULT_IMMUTABLE_CLASSES = new HashSet(13);
    private ReentrantReadWriteLock.ReadLock readLock;
    private ReentrantReadWriteLock.WriteLock writeLock;
    private boolean cloned = false;
    private Map<K, V> map;
    private Set<Class<?>> immutableClasses;

    static {
        DEFAULT_IMMUTABLE_CLASSES.add(String.class);
        DEFAULT_IMMUTABLE_CLASSES.add(BigDecimal.class);
        DEFAULT_IMMUTABLE_CLASSES.add(BigInteger.class);
        DEFAULT_IMMUTABLE_CLASSES.add(Byte.class);
        DEFAULT_IMMUTABLE_CLASSES.add(Double.class);
        DEFAULT_IMMUTABLE_CLASSES.add(Float.class);
        DEFAULT_IMMUTABLE_CLASSES.add(Integer.class);
        DEFAULT_IMMUTABLE_CLASSES.add(Long.class);
        DEFAULT_IMMUTABLE_CLASSES.add(Short.class);
        DEFAULT_IMMUTABLE_CLASSES.add(Boolean.class);
        DEFAULT_IMMUTABLE_CLASSES.add(Date.class);
        DEFAULT_IMMUTABLE_CLASSES.add(Locale.class);
    }

    public static <S extends Serializable> S protectValue(S value, Set<Class<?>> immutableClasses) {
        if (!ValueProtectingMap.mustProtectValue(value, immutableClasses)) {
            return value;
        }
        return (S)((Serializable)SerializationUtils.deserialize((byte[])SerializationUtils.serialize(value)));
    }

    public static <S extends Serializable> boolean mustProtectValue(S value, Set<Class<?>> immutableClasses) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return !DEFAULT_IMMUTABLE_CLASSES.contains(clazz) && !immutableClasses.contains(clazz);
    }

    public static <K extends Serializable, V extends Serializable> Map<K, V> cloneMap(Map<K, V> map, Set<Class<?>> immutableClasses) {
        HashMap<Serializable, Serializable> copy = new HashMap<Serializable, Serializable>((int)((double)map.size() * 1.3));
        for (Map.Entry<K, V> element : map.entrySet()) {
            Serializable key = (Serializable)element.getKey();
            Serializable value = (Serializable)element.getValue();
            key = ValueProtectingMap.protectValue(key, immutableClasses);
            value = ValueProtectingMap.protectValue(value, immutableClasses);
            copy.put(key, value);
        }
        return copy;
    }

    public ValueProtectingMap(Map<K, V> protectedMap) {
        this(protectedMap, null);
    }

    public ValueProtectingMap(Map<K, V> protectedMap, Set<Class<?>> immutableClasses) {
        if (protectedMap instanceof ValueProtectingMap) {
            ValueProtectingMap mapTemp = (ValueProtectingMap)protectedMap;
            this.map = mapTemp.map;
        } else {
            this.map = protectedMap;
        }
        this.cloned = false;
        this.immutableClasses = immutableClasses == null ? Collections.emptySet() : new HashSet(immutableClasses);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    Map<K, V> getProtectedMap() {
        return this.map;
    }

    private void cloneMap() {
        this.readLock.lock();
        try {
            if (this.cloned) {
                return;
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            if (this.cloned) {
                return;
            }
            Map<K, V> copy = ValueProtectingMap.cloneMap(this.map, this.immutableClasses);
            this.map = copy;
            this.cloned = true;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int size() {
        this.readLock.lock();
        try {
            int n = this.map.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.map.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        this.readLock.lock();
        try {
            boolean bl = this.map.containsKey(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        this.readLock.lock();
        try {
            boolean bl = this.map.containsValue(value);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int hashCode() {
        this.readLock.lock();
        try {
            int n = this.map.hashCode();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean equals(Object obj) {
        this.readLock.lock();
        try {
            boolean bl = this.map.equals(obj);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String toString() {
        this.readLock.lock();
        try {
            String string = this.map.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public V get(Object key) {
        this.readLock.lock();
        try {
            Serializable value = (Serializable)this.map.get(key);
            Serializable serializable = ValueProtectingMap.protectValue(value, this.immutableClasses);
            return (V)serializable;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public V put(K key, V value) {
        this.cloneMap();
        return (V)((Serializable)this.map.put(key, value));
    }

    @Override
    public V remove(Object key) {
        this.cloneMap();
        return (V)((Serializable)this.map.remove(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.cloneMap();
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.cloneMap();
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        this.cloneMap();
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        this.cloneMap();
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.cloneMap();
        return this.map.entrySet();
    }
}

