/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;

public class PathUtil {
    public static String getDisplayPath(Path path, boolean showLeaf) {
        StringBuilder buf = new StringBuilder(64);
        int count = path.size() - (showLeaf ? 0 : 1);
        int i = 0;
        while (i < count) {
            String elementString = null;
            Path.Element element = path.get(i);
            if (element instanceof Path.ChildAssocElement) {
                ChildAssociationRef elementRef = ((Path.ChildAssocElement)element).getRef();
                if (elementRef.getParentRef() != null) {
                    elementString = elementRef.getQName().getLocalName();
                }
            } else {
                elementString = element.getElementString();
            }
            if (elementString != null) {
                buf.append("/");
                buf.append(elementString);
            }
            ++i;
        }
        return buf.toString();
    }

    public static List<String> getNodeIdsInReverse(Path path, boolean showLeaf) {
        int count = path.size() - (showLeaf ? 1 : 2);
        if (count < 0) {
            return Collections.emptyList();
        }
        ArrayList<String> nodeIds = new ArrayList<String>(count);
        int i = count;
        while (i >= 0) {
            Path.Element element = path.get(i);
            if (element instanceof Path.ChildAssocElement) {
                Path.ChildAssocElement childAssocElem = (Path.ChildAssocElement)element;
                NodeRef childNodeRef = childAssocElem.getRef().getChildRef();
                nodeIds.add(childNodeRef.getId());
            }
            --i;
        }
        return nodeIds;
    }
}

