/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.repository.AbstractTransformationSourceOptions;
import org.alfresco.service.cmr.repository.SerializedTransformationOptionsAccessor;
import org.alfresco.service.cmr.repository.TransformationSourceOptions;

@Deprecated
public class TemporalSourceOptions
extends AbstractTransformationSourceOptions {
    private static final String VALID_TIME_STRING_REGEX = "\\d{2}:[0-5][0-9]:[0-5][0-9](\\.\\d{1,3})?";
    private String offset;
    private String duration;

    @Override
    public boolean isApplicableForMimetype(String sourceMimetype) {
        return sourceMimetype != null && sourceMimetype.startsWith("video/") || sourceMimetype.startsWith("audio/") || super.isApplicableForMimetype(sourceMimetype);
    }

    public String getOffset() {
        return this.offset;
    }

    public void setOffset(String offset) {
        TemporalSourceOptions.validateTimeString(offset);
        this.offset = offset;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        TemporalSourceOptions.validateTimeString(duration);
        this.duration = duration;
    }

    public static void validateTimeString(String value) {
        if (value != null && !value.matches(VALID_TIME_STRING_REGEX)) {
            throw new AlfrescoRuntimeException("'" + value + "' is not a valid time specification of the form hh:mm:ss[.xxx]");
        }
    }

    @Override
    public TransformationSourceOptions mergedOptions(TransformationSourceOptions overridingOptions) {
        if (overridingOptions instanceof TemporalSourceOptions) {
            TemporalSourceOptions mergedOptions = (TemporalSourceOptions)super.mergedOptions(overridingOptions);
            if (((TemporalSourceOptions)overridingOptions).getOffset() != null) {
                mergedOptions.setOffset(((TemporalSourceOptions)overridingOptions).getOffset());
            }
            if (((TemporalSourceOptions)overridingOptions).getDuration() != null) {
                mergedOptions.setDuration(((TemporalSourceOptions)overridingOptions).getDuration());
            }
            return mergedOptions;
        }
        return null;
    }

    @Override
    public TransformationSourceOptions.TransformationSourceOptionsSerializer getSerializer() {
        return TemporalSourceOptions.createSerializerInstance();
    }

    public static TransformationSourceOptions.TransformationSourceOptionsSerializer createSerializerInstance() {
        return new TemporalSourceOptions().new TemporalSourceOptionsSerializer();
    }

    public class TemporalSourceOptionsSerializer
    implements TransformationSourceOptions.TransformationSourceOptionsSerializer {
        public static final String PARAM_SOURCE_TIME_OFFSET = "source_time_offset";
        public static final String PARAM_SOURCE_TIME_DURATION = "source_time_duration";

        @Override
        public TransformationSourceOptions deserialize(SerializedTransformationOptionsAccessor serializedOptions) {
            String offset = serializedOptions.getCheckedParam(PARAM_SOURCE_TIME_OFFSET, String.class);
            String duration = serializedOptions.getCheckedParam(PARAM_SOURCE_TIME_DURATION, String.class);
            if (offset == null && duration == null) {
                return null;
            }
            TemporalSourceOptions sourceOptions = new TemporalSourceOptions();
            sourceOptions.setOffset(offset);
            sourceOptions.setDuration(duration);
            return sourceOptions;
        }

        @Override
        public void serialize(TransformationSourceOptions sourceOptions, Map<String, Serializable> parameters) {
            if (parameters == null || sourceOptions == null) {
                return;
            }
            TemporalSourceOptions temporalSourceOptions = (TemporalSourceOptions)sourceOptions;
            parameters.put(PARAM_SOURCE_TIME_OFFSET, (Serializable)((Object)temporalSourceOptions.getOffset()));
            parameters.put(PARAM_SOURCE_TIME_DURATION, (Serializable)((Object)temporalSourceOptions.getDuration()));
        }
    }
}

