/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.model.ContentModel;
import org.alfresco.service.Auditable;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.DirectAccessUrl;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

@AlfrescoPublicApi
public interface ContentService {
    public long getStoreTotalSpace();

    public long getStoreFreeSpace();

    @Auditable(parameters={"contentUrl"})
    public ContentReader getRawReader(String var1);

    @Auditable(parameters={"nodeRef", "propertyQName"})
    public ContentReader getReader(NodeRef var1, QName var2) throws InvalidNodeRefException, InvalidTypeException;

    @Auditable(parameters={"nodeRef", "propertyQName", "update"})
    public ContentWriter getWriter(NodeRef var1, QName var2, boolean var3) throws InvalidNodeRefException, InvalidTypeException;

    @Auditable
    public ContentWriter getTempWriter();

    public boolean isContentDirectUrlEnabled();

    @Deprecated
    default public boolean isContentDirectUrlEnabled(NodeRef nodeRef) {
        return this.isContentDirectUrlEnabled(nodeRef, ContentModel.PROP_CONTENT);
    }

    public boolean isContentDirectUrlEnabled(NodeRef var1, QName var2);

    @Deprecated
    default public DirectAccessUrl requestContentDirectUrl(NodeRef nodeRef, boolean attachment) {
        return this.requestContentDirectUrl(nodeRef, attachment, null);
    }

    default public DirectAccessUrl requestContentDirectUrl(NodeRef nodeRef, QName propertyQName, boolean attachment) {
        return this.requestContentDirectUrl(nodeRef, propertyQName, attachment, null);
    }

    @Auditable(parameters={"nodeRef", "validFor"})
    @Deprecated
    default public DirectAccessUrl requestContentDirectUrl(NodeRef nodeRef, boolean attachment, Long validFor) {
        return this.requestContentDirectUrl(nodeRef, ContentModel.PROP_CONTENT, attachment, validFor);
    }

    @Auditable(parameters={"nodeRef", "propertyQName", "validFor"})
    default public DirectAccessUrl requestContentDirectUrl(NodeRef nodeRef, QName propertyQName, boolean attachment, Long validFor) {
        return this.requestContentDirectUrl(nodeRef, propertyQName, attachment, validFor, null);
    }

    @Auditable(parameters={"nodeRef", "propertyQName", "validFor"})
    public DirectAccessUrl requestContentDirectUrl(NodeRef var1, QName var2, boolean var3, Long var4, String var5);

    @Auditable(parameters={"nodeRef", "propertyQName"})
    default public Map<String, String> getStorageProperties(NodeRef nodeRef, QName propertyQName) {
        return Collections.emptyMap();
    }

    @Auditable(parameters={"nodeRef", "propertyQName", "archiveParams"})
    default public boolean requestSendContentToArchive(NodeRef nodeRef, QName propertyQName, Map<String, Serializable> archiveParams) {
        throw new UnsupportedOperationException("Request to archive content is not supported by content service.");
    }

    @Auditable(parameters={"nodeRef", "propertyQName", "restoreParams"})
    default public boolean requestRestoreContentFromArchive(NodeRef nodeRef, QName propertyQName, Map<String, Serializable> restoreParams) {
        throw new UnsupportedOperationException("Request to restore content from archive is not supported by content service.");
    }
}

