/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.download;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;

public class DownloadRequest {
    private String owner;
    private boolean recursive;
    private List<AssociationRef> requestedNodes;

    public DownloadRequest(boolean recursive, List<AssociationRef> requestedNodes, String owner) {
        this.owner = owner;
        this.recursive = recursive;
        this.requestedNodes = requestedNodes;
    }

    public List<AssociationRef> getRequetedNodes() {
        return this.requestedNodes;
    }

    public NodeRef[] getRequetedNodeRefs() {
        ArrayList<NodeRef> requestedNodeRefs = new ArrayList<NodeRef>(this.requestedNodes.size());
        for (AssociationRef requestedNode : this.requestedNodes) {
            requestedNodeRefs.add(requestedNode.getTargetRef());
        }
        return requestedNodeRefs.toArray(new NodeRef[requestedNodeRefs.size()]);
    }

    public String getOwner() {
        return this.owner;
    }
}

