/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.List;
import org.alfresco.repo.virtual.ref.ClasspathResource;
import org.alfresco.repo.virtual.ref.Encodings;
import org.alfresco.repo.virtual.ref.HashStore;
import org.alfresco.repo.virtual.ref.HashStoreConfiguration;
import org.alfresco.repo.virtual.ref.NodeHashStringifier;
import org.alfresco.repo.virtual.ref.Parameter;
import org.alfresco.repo.virtual.ref.Protocol;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.ReferenceEncodingException;
import org.alfresco.repo.virtual.ref.ReferenceParameter;
import org.alfresco.repo.virtual.ref.RepositoryLocation;
import org.alfresco.repo.virtual.ref.RepositoryNodeRef;
import org.alfresco.repo.virtual.ref.RepositoryPath;
import org.alfresco.repo.virtual.ref.RepositoryResource;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.ResourceParameter;
import org.alfresco.repo.virtual.ref.StringParameter;
import org.alfresco.repo.virtual.ref.Stringifier;
import org.alfresco.repo.virtual.ref.VanillaHashStringifier;
import org.alfresco.repo.virtual.ref.VirtualHashStringifier;

public class HashStringifier
implements Stringifier {
    private static final long serialVersionUID = 2213824445193662644L;
    private NodeHashStringifier nodeStringifier;
    private VirtualHashStringifier virtualStringifier;
    private VanillaHashStringifier vanillaStringifier;

    public HashStringifier() {
        HashStore cpStore = HashStoreConfiguration.getInstance().getClasspathHashStore();
        this.nodeStringifier = new NodeHashStringifier(cpStore, this);
        this.virtualStringifier = new VirtualHashStringifier(cpStore, this);
        this.vanillaStringifier = new VanillaHashStringifier(cpStore, this);
    }

    @Override
    public String stringify(Reference reference) throws ReferenceEncodingException {
        Protocol protocol = reference.getProtocol();
        if (Protocols.NODE.protocol.equals(protocol)) {
            return this.nodeStringifier.stringify(reference);
        }
        if (Protocols.VIRTUAL.protocol.equals(protocol)) {
            return this.virtualStringifier.stringify(reference);
        }
        if (Protocols.VANILLA.protocol.equals(protocol)) {
            return this.vanillaStringifier.stringify(reference);
        }
        return this.stringifyUnknown(reference);
    }

    private String stringifyUnknown(Reference reference) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Could not stringify unknown protocol reference s" + reference.encode(Encodings.PLAIN.encoding));
    }

    @Override
    public String stringify(Resource resource) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Unknown hash protocol.");
    }

    @Override
    public String stringifyResource(Resource resource) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Unknown hash protocol.");
    }

    @Override
    public String stringifyResource(RepositoryResource resource) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Unknown hash protocol.");
    }

    @Override
    public String stringifyResource(ClasspathResource resource) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Unknown hash protocol.");
    }

    @Override
    public String stringify(RepositoryLocation repositoryLocation) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Unknown hash protocol.");
    }

    @Override
    public String stringifyRepositoryLocation(RepositoryLocation repositoryLocation) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Unknown hash protocol.");
    }

    @Override
    public String stringifyRepositoryLocation(RepositoryNodeRef repositoryNodeRef) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Unknown hash protocol.");
    }

    @Override
    public String stringifyRepositoryLocation(RepositoryPath repositoryPath) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Unknown hash protocol.");
    }

    @Override
    public String stringify(List<Parameter> parameters) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Unknown hash protocol.");
    }

    @Override
    public String stringify(Parameter parameter) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Unknown hash protocol.");
    }

    @Override
    public String stringifyParameter(Parameter parameter) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Unknown hash protocol.");
    }

    @Override
    public String stringifyParameter(ResourceParameter resourceParameter) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Unknown hash protocol.");
    }

    @Override
    public String stringifyParameter(StringParameter stringParameter) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Unknown hash protocol.");
    }

    @Override
    public String stringifyParameter(ReferenceParameter referenceParameter) throws ReferenceEncodingException {
        throw new ReferenceEncodingException("Unknown hash protocol.");
    }
}

