/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import org.alfresco.repo.virtual.ref.HashEncodingArtefact;
import org.alfresco.repo.virtual.ref.HashStore;
import org.alfresco.repo.virtual.ref.HashStoreConfiguration;
import org.alfresco.repo.virtual.ref.NodeHashReferenceParser;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.ReferenceEncodingException;
import org.alfresco.repo.virtual.ref.ReferenceParseException;
import org.alfresco.repo.virtual.ref.ReferenceParser;
import org.alfresco.repo.virtual.ref.VanillaHashReferenceParser;
import org.alfresco.repo.virtual.ref.VirtualHashReferenceParser;

public class HashReferenceParser
implements ReferenceParser,
HashEncodingArtefact {
    private static final long serialVersionUID = -2569625423953183530L;
    private NodeHashReferenceParser nodeReferenceParser;
    private VirtualHashReferenceParser virtualReferenceParser;
    private VanillaHashReferenceParser vanillaReferenceParser;

    public HashReferenceParser() {
        HashStore cpStore = HashStoreConfiguration.getInstance().getClasspathHashStore();
        this.nodeReferenceParser = new NodeHashReferenceParser(cpStore, this);
        this.virtualReferenceParser = new VirtualHashReferenceParser(cpStore);
        this.vanillaReferenceParser = new VanillaHashReferenceParser(cpStore);
    }

    @Override
    public Reference parse(String referenceString) throws ReferenceParseException {
        String[] tokens = referenceString.split("-");
        ReferenceParser.Cursor c = new ReferenceParser.Cursor(tokens, 0);
        return this.parse(c);
    }

    public Reference parse(ReferenceParser.Cursor c) {
        if ("3".equals(c.currentToken())) {
            return this.nodeReferenceParser.parse(c);
        }
        if ("1".equals(c.currentToken())) {
            return this.vanillaReferenceParser.parse(c);
        }
        if ("2".equals(c.currentToken())) {
            return this.virtualReferenceParser.parse(c);
        }
        throw new ReferenceEncodingException("Unknown reference code " + c.currentToken());
    }
}

