/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.usage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.usage.UsageDAO;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.Tenant;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionServiceImpl;
import org.alfresco.repo.usage.ContentUsageImpl;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.usage.UsageService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class UserUsageTrackingComponent
extends AbstractLifecycleBean
implements NodeServicePolicies.OnCreateNodePolicy {
    private static Log logger = LogFactory.getLog(UserUsageTrackingComponent.class);
    private TransactionServiceImpl transactionService;
    private ContentUsageImpl contentUsageImpl;
    private NodeService nodeService;
    private UsageDAO usageDAO;
    private UsageService usageService;
    private TenantAdminService tenantAdminService;
    private TenantService tenantService;
    private JobLockService jobLockService;
    private StoreRef personStoreRef;
    private int clearBatchSize = 50;
    private int updateBatchSize = 50;
    private boolean enabled = true;
    private static final long LOCK_TTL = 60000L;
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"org.alfresco.repo.usage.UserUsageTrackingComponent");
    private PolicyComponent policyComponent;

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"jobLockService", (Object)this.jobLockService);
        if (this.enabled) {
            this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnCreateNodePolicy.QNAME, ContentModel.TYPE_PERSON, (Behaviour)new JavaBehaviour(this, "onCreateNode"));
        }
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setTransactionService(TransactionServiceImpl transactionService) {
        this.transactionService = transactionService;
    }

    public void setContentUsageImpl(ContentUsageImpl contentUsageImpl) {
        this.contentUsageImpl = contentUsageImpl;
    }

    public void setPersonStoreUrl(String storeUrl) {
        this.personStoreRef = new StoreRef(storeUrl);
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setUsageDAO(UsageDAO usageDAO) {
        this.usageDAO = usageDAO;
    }

    public void setUsageService(UsageService usageService) {
        this.usageService = usageService;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setClearBatchSize(int clearBatchSize) {
        this.clearBatchSize = clearBatchSize;
    }

    public void setUpdateBatchSize(int updateBatchSize) {
        this.updateBatchSize = updateBatchSize;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    private String getLock(long time) {
        try {
            return this.jobLockService.getLock(LOCK_QNAME, time);
        }
        catch (LockAcquisitionException lockAcquisitionException) {
            return null;
        }
    }

    public void execute() {
        if (!this.enabled || this.transactionService.isReadOnly()) {
            return;
        }
        String lockToken = this.getLock(60000L);
        if (lockToken != null) {
            TrackingJobLockRefreshCallback callback = new TrackingJobLockRefreshCallback();
            this.jobLockService.refreshLock(lockToken, LOCK_QNAME, 60000L, callback);
            try {
                this.collapseUsages();
            }
            finally {
                callback.stopRefreshing();
                this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
            }
        }
    }

    protected void onBootstrap(ApplicationEvent event) {
        this.bootstrapInternal();
        if (this.tenantAdminService.isEnabled()) {
            List<Tenant> tenants = this.tenantAdminService.getAllTenants();
            for (Tenant tenant : tenants) {
                TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        UserUsageTrackingComponent.this.bootstrapInternal();
                        return null;
                    }
                }, (String)tenant.getTenantDomain());
            }
        }
    }

    public void bootstrapInternal() {
        if (this.transactionService.isReadOnly()) {
            return;
        }
        String lockToken = this.getLock(60000L);
        if (lockToken != null) {
            TrackingJobLockRefreshCallback callback = new TrackingJobLockRefreshCallback();
            this.jobLockService.refreshLock(lockToken, LOCK_QNAME, 60000L, callback);
            try {
                if (this.enabled) {
                    this.calculateMissingUsages();
                } else if (this.clearBatchSize != 0) {
                    this.clearAllUsages();
                }
            }
            finally {
                callback.stopRefreshing();
                this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
            }
        }
    }

    @Override
    public void onCreateNode(ChildAssociationRef childAssocRef) {
        NodeRef personRef;
        String userName;
        if (this.enabled && (userName = (String)((Object)this.nodeService.getProperty(personRef = childAssocRef.getChildRef(), ContentModel.PROP_USERNAME))) != null) {
            RetryingTransactionHelper.RetryingTransactionCallback<Long> updateUserWithUsage = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                @Override
                public Long execute() throws Throwable {
                    List<String> stores = UserUsageTrackingComponent.this.contentUsageImpl.getStores();
                    Long currentUsage = null;
                    for (String store : stores) {
                        StoreRef storeRef = UserUsageTrackingComponent.this.tenantService.getName(new StoreRef(store));
                        Long contentSize = UserUsageTrackingComponent.this.usageDAO.getContentSizeForStoreForUser(storeRef, userName);
                        if (contentSize == null) continue;
                        currentUsage = (currentUsage == null ? 0L : currentUsage) + contentSize;
                    }
                    if (currentUsage != null && currentUsage > 0L) {
                        ArrayList<Pair<NodeRef, Long>> batchUserUsages = new ArrayList<Pair<NodeRef, Long>>(1);
                        batchUserUsages.add(new Pair((Object)personRef, (Object)currentUsage));
                        UserUsageTrackingComponent.this.updateUsages(batchUserUsages);
                    }
                    return null;
                }
            };
            this.transactionService.getRetryingTransactionHelper().doInTransaction(updateUserWithUsage, false);
        }
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    private void clearAllUsages() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Disabled - clear non-missing user usages ...");
        }
        final HashMap users = new HashMap();
        RetryingTransactionHelper.RetryingTransactionCallback<Object> getUsersWithUsage = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                UsageDAO.MapHandler userHandler = new UsageDAO.MapHandler(){

                    @Override
                    public void handle(Map<String, Object> result) {
                        String username = (String)result.get("username");
                        String uuid = (String)result.get("uuid");
                        if (!username.equalsIgnoreCase(AuthenticationUtil.getSystemUserName())) {
                            users.put(username, new NodeRef((this).UserUsageTrackingComponent.this.personStoreRef, uuid));
                        }
                    }
                };
                UserUsageTrackingComponent.this.usageDAO.getUsersWithUsage(UserUsageTrackingComponent.this.tenantService.getName(UserUsageTrackingComponent.this.personStoreRef), userHandler);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(getUsersWithUsage, true);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Found " + users.size() + " users to clear"));
        }
        int clearCount = 0;
        int batchCount = 0;
        int totalCount = 0;
        ArrayList<NodeRef> batchPersonRefs = new ArrayList<NodeRef>(this.clearBatchSize);
        for (NodeRef personNodeRef : users.values()) {
            batchPersonRefs.add(personNodeRef);
            if (++batchCount != this.clearBatchSize && ++totalCount != users.size()) continue;
            int cleared = this.clearUsages(batchPersonRefs);
            clearCount += cleared;
            batchPersonRefs.clear();
            batchCount = 0;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("... cleared non-missing usages for " + clearCount + " users"));
        }
    }

    private int clearUsages(final List<NodeRef> personNodeRefs) {
        RetryingTransactionHelper.RetryingTransactionCallback<Integer> clearPersonUsage = new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

            @Override
            public Integer execute() throws Throwable {
                int clearCount = 0;
                for (NodeRef personNodeRef : personNodeRefs) {
                    UserUsageTrackingComponent.this.nodeService.setProperty(personNodeRef, ContentModel.PROP_SIZE_CURRENT, (Serializable)Long.valueOf(-1L));
                    UserUsageTrackingComponent.this.usageService.deleteDeltas(personNodeRef);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Cleared usage for person (" + String.valueOf(personNodeRef) + ")"));
                    }
                    ++clearCount;
                }
                return clearCount;
            }
        };
        return this.transactionService.getRetryingTransactionHelper().doInTransaction(clearPersonUsage, false);
    }

    private void calculateMissingUsages() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Enabled - calculate missing user usages ...");
        }
        final HashMap<String, NodeRef> users = new HashMap<String, NodeRef>();
        RetryingTransactionHelper.RetryingTransactionCallback<Object> getUsersWithoutUsage = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                UsageDAO.MapHandler userHandler = new UsageDAO.MapHandler(){

                    @Override
                    public void handle(Map<String, Object> result) {
                        String username = (String)result.get("username");
                        String uuid = (String)result.get("uuid");
                        if (!username.equalsIgnoreCase(AuthenticationUtil.getSystemUserName())) {
                            users.put(username, new NodeRef((this).UserUsageTrackingComponent.this.personStoreRef, uuid));
                        }
                    }
                };
                UserUsageTrackingComponent.this.usageDAO.getUsersWithoutUsage(UserUsageTrackingComponent.this.tenantService.getName(UserUsageTrackingComponent.this.personStoreRef), userHandler);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(getUsersWithoutUsage, true);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Found " + users.size() + " users to recalculate"));
        }
        int updateCount = 0;
        if (users.size() > 0) {
            updateCount = this.recalculateUsages(users);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("... calculated missing usages for " + updateCount + " users"));
        }
    }

    private int recalculateUsages(Map<String, NodeRef> users) {
        final HashMap currentUserUsages = new HashMap(users.size());
        RetryingTransactionHelper.RetryingTransactionCallback<Long> calculateCurrentUsages = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            @Override
            public Long execute() throws Throwable {
                List<String> stores = UserUsageTrackingComponent.this.contentUsageImpl.getStores();
                for (String store : stores) {
                    StoreRef storeRef = UserUsageTrackingComponent.this.tenantService.getName(new StoreRef(store));
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Recalc usages for store=" + String.valueOf(storeRef)));
                    }
                    UsageDAO.MapHandler userContentUrlHandler = new UsageDAO.MapHandler(){

                        @Override
                        public void handle(Map<String, Object> result) {
                            Long currentUsage;
                            String owner = (String)result.get("owner");
                            String creator = (String)result.get("creator");
                            Long contentSize = (Long)result.get("contentSize");
                            if (contentSize == null) {
                                contentSize = 0L;
                            }
                            if (owner == null) {
                                owner = creator;
                            }
                            if ((currentUsage = (Long)currentUserUsages.get(owner)) == null) {
                                currentUsage = 0L;
                            }
                            currentUserUsages.put(owner, currentUsage + contentSize);
                        }
                    };
                    UserUsageTrackingComponent.this.usageDAO.getUserContentSizesForStore(storeRef, userContentUrlHandler);
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(calculateCurrentUsages, true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Usages calculated - start update");
        }
        int updateCount = 0;
        int batchCount = 0;
        int totalCount = 0;
        ArrayList<Pair<NodeRef, Long>> batchUserUsages = new ArrayList<Pair<NodeRef, Long>>(this.updateBatchSize);
        for (Map.Entry<String, NodeRef> user : users.entrySet()) {
            String userName = user.getKey();
            NodeRef personNodeRef = user.getValue();
            Long currentUsage = (Long)currentUserUsages.get(userName);
            if (currentUsage == null) {
                currentUsage = 0L;
            }
            batchUserUsages.add(new Pair((Object)personNodeRef, (Object)currentUsage));
            if (++batchCount != this.updateBatchSize && ++totalCount != users.size()) continue;
            int updated = this.updateUsages(batchUserUsages);
            updateCount += updated;
            batchUserUsages.clear();
            batchCount = 0;
        }
        return totalCount;
    }

    private int updateUsages(final List<Pair<NodeRef, Long>> userUsages) {
        RetryingTransactionHelper.RetryingTransactionCallback<Integer> updateCurrentUsages = new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

            @Override
            public Integer execute() throws Throwable {
                int updateCount = 0;
                for (Pair userUsage : userUsages) {
                    NodeRef personNodeRef = (NodeRef)userUsage.getFirst();
                    Long currentUsage = (Long)userUsage.getSecond();
                    UserUsageTrackingComponent.this.contentUsageImpl.setUserStoredUsage(personNodeRef, currentUsage);
                    UserUsageTrackingComponent.this.usageService.deleteDeltas(personNodeRef);
                    ++updateCount;
                }
                return updateCount;
            }
        };
        return this.transactionService.getRetryingTransactionHelper().doInTransaction(updateCurrentUsages, false);
    }

    private void collapseUsages() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Collapse usages ...");
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Set<NodeRef>> getUsageNodeRefs = new RetryingTransactionHelper.RetryingTransactionCallback<Set<NodeRef>>(){

            @Override
            public Set<NodeRef> execute() throws Throwable {
                return UserUsageTrackingComponent.this.usageService.getUsageDeltaNodes();
            }
        };
        Set<NodeRef> usageNodeRefs = this.transactionService.getRetryingTransactionHelper().doInTransaction(getUsageNodeRefs, true);
        int collapseCount = 0;
        for (final NodeRef usageNodeRef : usageNodeRefs) {
            Boolean collapsed = (Boolean)TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Boolean>(){

                public Boolean doWork() throws Exception {
                    return UserUsageTrackingComponent.this.collapseUsage(usageNodeRef);
                }
            }, (String)this.tenantService.getDomain(usageNodeRef.getStoreRef().getIdentifier()));
            if (!collapsed.booleanValue()) continue;
            ++collapseCount;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("... collapsed usages for " + collapseCount + " users"));
        }
    }

    private boolean collapseUsage(final NodeRef usageNodeRef) {
        RetryingTransactionHelper.RetryingTransactionCallback<Boolean> collapseUsages = new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

            @Override
            public Boolean execute() throws Throwable {
                if (!UserUsageTrackingComponent.this.nodeService.exists(usageNodeRef)) {
                    return false;
                }
                QName nodeType = UserUsageTrackingComponent.this.nodeService.getType(usageNodeRef);
                if (nodeType.equals((Object)ContentModel.TYPE_PERSON)) {
                    NodeRef personNodeRef = usageNodeRef;
                    String userName = (String)((Object)UserUsageTrackingComponent.this.nodeService.getProperty(personNodeRef, ContentModel.PROP_USERNAME));
                    long currentUsage = UserUsageTrackingComponent.this.contentUsageImpl.getUserStoredUsage(personNodeRef);
                    if (currentUsage != -1L) {
                        currentUsage = UserUsageTrackingComponent.this.contentUsageImpl.getUserUsage(personNodeRef, true);
                        UserUsageTrackingComponent.this.contentUsageImpl.setUserStoredUsage(personNodeRef, currentUsage);
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Collapsed usage: username=" + userName + ", usage=" + currentUsage));
                        }
                    } else if (logger.isWarnEnabled()) {
                        logger.warn((Object)("Initial usage for user has not yet been calculated: " + userName));
                    }
                }
                return true;
            }
        };
        return this.transactionService.getRetryingTransactionHelper().doInTransaction(collapseUsages, false);
    }

    private class TrackingJobLockRefreshCallback
    implements JobLockService.JobLockRefreshCallback {
        private final AtomicBoolean running = new AtomicBoolean(true);

        private TrackingJobLockRefreshCallback() {
        }

        @Override
        public boolean isActive() {
            return this.running.get();
        }

        public void stopRefreshing() {
            this.running.set(false);
        }

        @Override
        public void lockReleased() {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"lock released");
            }
        }
    }
}

