/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.util.List;
import org.alfresco.repo.template.BaseTemplateProcessorExtension;
import org.apache.commons.lang3.StringUtils;

public class DocumentationURLMethod
extends BaseTemplateProcessorExtension
implements TemplateMethodModelEx {
    private static final String COMPONENT_SEARCHENTERPRISE = "elasticsearch";
    private static final String COMPONENT_SEARCH = "solr";
    private String documentationBaseUrl;
    private String acsVersion;
    private String alfrescoSearchVersion;
    private String alfrescoSearchEnterpriseVersion;
    private String defaultDocumentationUrl;

    public void setDefaultDocumentationUrl(String defaultDocumentationUrl) {
        this.defaultDocumentationUrl = defaultDocumentationUrl;
    }

    public void setAcsVersion(String acsVersion) {
        this.acsVersion = acsVersion;
    }

    public void setAlfrescoSearchVersion(String alfrescoSearchVersion) {
        this.alfrescoSearchVersion = alfrescoSearchVersion;
    }

    public void setAlfrescoSearchEnterpriseVersion(String alfrescoSearchEnterpriseVersion) {
        this.alfrescoSearchEnterpriseVersion = alfrescoSearchEnterpriseVersion;
    }

    public void setDocumentationBaseUrl(String documentationBaseUrl) {
        this.documentationBaseUrl = documentationBaseUrl;
    }

    public Object exec(List args) throws TemplateModelException {
        String topicUid = this.getTopicUid(args);
        String urlComponent = this.getUrlComponent(args);
        String alfrescoComponent = this.getAlfrescoComponent(args);
        return this.getDocumentationUrl(topicUid, urlComponent, alfrescoComponent);
    }

    public String getDocumentationUrl() {
        return this.defaultDocumentationUrl;
    }

    public String getDocumentationUrl(String topicUid, String urlComponent, String alfrescoComponent) {
        if (StringUtils.isEmpty((CharSequence)topicUid) && StringUtils.isEmpty((CharSequence)urlComponent)) {
            return this.getDocumentationUrl();
        }
        String version = this.selectVersion(alfrescoComponent);
        return this.documentationBaseUrl + topicUid + version + urlComponent;
    }

    private String selectVersion(String alfrescoComponent) {
        if (COMPONENT_SEARCHENTERPRISE.equalsIgnoreCase(alfrescoComponent)) {
            return this.alfrescoSearchEnterpriseVersion;
        }
        if (COMPONENT_SEARCH.equalsIgnoreCase(alfrescoComponent)) {
            return this.alfrescoSearchVersion;
        }
        return this.acsVersion;
    }

    private String getStringArg(List<?> args, int index) throws TemplateModelException {
        Object arg;
        if (args.size() > index && (arg = args.get(index)) instanceof TemplateScalarModel) {
            String value = ((TemplateScalarModel)arg).getAsString();
            return value != null ? value : "";
        }
        return "";
    }

    private String getTopicUid(List<?> args) throws TemplateModelException {
        return this.getStringArg(args, 0);
    }

    private String getUrlComponent(List<?> args) throws TemplateModelException {
        return this.getStringArg(args, 1);
    }

    private String getAlfrescoComponent(List<?> args) throws TemplateModelException {
        return this.getStringArg(args, 2);
    }
}

