/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site;

import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.repo.site.SiteMembership;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.util.Pair;

public class SiteMembershipComparator
implements Comparator<SiteMembership> {
    private List<Pair<? extends Object, CannedQuerySortDetails.SortOrder>> sortPairs;
    private static Collator collator = Collator.getInstance();
    private Type comparatorType;

    public SiteMembershipComparator(List<Pair<? extends Object, CannedQuerySortDetails.SortOrder>> sortPairs, Type comparatorType) {
        if (sortPairs.size() < 1) {
            throw new IllegalArgumentException("Must provide at least one sort criterion");
        }
        this.sortPairs = sortPairs;
        this.comparatorType = comparatorType;
    }

    static <T> int safeCompare(Comparable<T> o1, T o2) {
        int ret = 0;
        ret = o1 == null ? (o2 == null ? 0 : -1) : (o2 == null ? 1 : o1.compareTo(o2));
        return ret;
    }

    private int safeCompare(String s1, String s2) {
        int ret = 0;
        ret = s1 == null ? (s2 == null ? 0 : -1) : (s2 == null ? 1 : collator.compare(s1, s2));
        return ret;
    }

    static int compareSiteMembersBody(List<Pair<? extends Object, CannedQuerySortDetails.SortOrder>> sortPairs, String personId1, String personId2, String lastName1, String lastName2, String siteRole1, String siteRole2, int personId, int firstName, int lastName, int siteRole, int ret) {
        for (Pair<? extends Object, CannedQuerySortDetails.SortOrder> pair : sortPairs) {
            int multiplier;
            Object name = pair.getFirst();
            CannedQuerySortDetails.SortOrder sortOrder = (CannedQuerySortDetails.SortOrder)pair.getSecond();
            int n = multiplier = sortOrder.equals((Object)CannedQuerySortDetails.SortOrder.ASCENDING) ? 1 : -1;
            if (name.equals((Object)SiteService.SortFields.FirstName)) {
                ret = firstName * multiplier;
            } else if (name.equals((Object)SiteService.SortFields.LastName)) {
                if (lastName1 == null || lastName2 == null) continue;
                ret = lastName * multiplier;
            } else if (name.equals((Object)SiteService.SortFields.Role)) {
                if (siteRole1 == null || siteRole2 == null) continue;
                ret = siteRole * multiplier;
            } else if (name.equals((Object)SiteService.SortFields.Username)) {
                if (personId1 == null || personId2 == null) continue;
                ret = personId * multiplier;
            }
            if (ret != 0) break;
        }
        return ret;
    }

    static int compareSiteGroupsBody(List<Pair<? extends Object, CannedQuerySortDetails.SortOrder>> sortPairs, String displayName1, String displayName2, String siteRole1, String siteRole2, int displayName, int siteRole, int ret) {
        for (Pair<? extends Object, CannedQuerySortDetails.SortOrder> pair : sortPairs) {
            int multiplier;
            Object name = pair.getFirst();
            CannedQuerySortDetails.SortOrder sortOrder = (CannedQuerySortDetails.SortOrder)pair.getSecond();
            int n = multiplier = sortOrder.equals((Object)CannedQuerySortDetails.SortOrder.ASCENDING) ? 1 : -1;
            if (name.equals((Object)SiteService.SortFields.DisplayName)) {
                if (displayName1 == null || displayName2 == null) continue;
                ret = displayName * multiplier;
            } else if (name.equals((Object)SiteService.SortFields.Role)) {
                if (siteRole1 == null || siteRole2 == null) continue;
                ret = siteRole * multiplier;
            }
            if (ret != 0) break;
        }
        return ret;
    }

    private int compareSitesBody(String shortName1, String shortName2, String siteRole1, String siteRole2, String siteTitle1, String siteTitle2, int siteShortName, int siteRole, int siteTitle, int ret) {
        for (Pair<? extends Object, CannedQuerySortDetails.SortOrder> pair : this.sortPairs) {
            int multiplier;
            Object name = pair.getFirst();
            CannedQuerySortDetails.SortOrder sortOrder = (CannedQuerySortDetails.SortOrder)pair.getSecond();
            int n = multiplier = sortOrder.equals((Object)CannedQuerySortDetails.SortOrder.ASCENDING) ? 1 : -1;
            if (name.equals((Object)SiteService.SortFields.SiteShortName)) {
                if (shortName1 == null || shortName2 == null) continue;
                ret = siteShortName * multiplier;
            } else if (name.equals((Object)SiteService.SortFields.SiteTitle)) {
                if (siteTitle1 == null || siteTitle2 == null) continue;
                ret = siteTitle * multiplier;
            } else if (name.equals((Object)SiteService.SortFields.Role)) {
                if (siteRole1 == null || siteRole2 == null) continue;
                ret = siteRole * multiplier;
            }
            if (ret != 0) break;
        }
        return ret;
    }

    @Override
    public int compare(SiteMembership o1, SiteMembership o2) {
        String personId1 = o1.getPersonId();
        String personId2 = o2.getPersonId();
        SiteInfo siteInfo1 = o1.getSiteInfo();
        SiteInfo siteInfo2 = o2.getSiteInfo();
        String shortName1 = siteInfo1.getShortName();
        String shortName2 = siteInfo2.getShortName();
        String firstName1 = o1.getFirstName();
        String firstName2 = o2.getFirstName();
        String lastName1 = o1.getLastName();
        String lastName2 = o2.getLastName();
        String siteRole1 = o1.getRole();
        String siteRole2 = o2.getRole();
        String siteTitle1 = siteInfo1.getTitle();
        String siteTitle2 = siteInfo2.getTitle();
        int personId = this.safeCompare(personId1, personId2);
        int firstName = this.safeCompare(firstName1, firstName2);
        int siteShortName = this.safeCompare(shortName1, shortName2);
        int lastName = this.safeCompare(lastName1, lastName2);
        int siteRole = this.safeCompare(siteRole1, siteRole2);
        int siteTitle = this.safeCompare(siteTitle1, siteTitle2);
        if (siteRole == 0 && siteShortName == 0 && personId == 0) {
            return 0;
        }
        int ret = 0;
        switch (this.comparatorType) {
            case SITES: {
                ret = this.compareSitesBody(shortName1, shortName2, siteRole1, siteRole2, siteTitle1, siteTitle2, siteShortName, siteRole, siteTitle, ret);
                break;
            }
            case MEMBERS: {
                ret = SiteMembershipComparator.compareSiteMembersBody(this.sortPairs, personId1, personId2, lastName1, lastName2, siteRole1, siteRole2, personId, firstName, lastName, siteRole, ret);
            }
        }
        return ret;
    }

    public static enum Type {
        SITES,
        MEMBERS;

    }
}

