/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.person;

import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.person.PermissionsManager;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class CheckAndFixPersonPermissionsBootstrapBean
extends AbstractLifecycleBean {
    protected static final Log log = LogFactory.getLog(CheckAndFixPersonPermissionsBootstrapBean.class);
    private NodeService nodeService;
    private PersonService personService;
    private TransactionService transactionService;
    private PermissionsManager permissionsManager;
    private Set<String> excludedUsers;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setPermissionsManager(PermissionsManager permissionsManager) {
        this.permissionsManager = permissionsManager;
    }

    public void setExcludedUsers(Set<String> excludedUsers) {
        this.excludedUsers = excludedUsers;
    }

    protected void onBootstrap(ApplicationEvent event) {
        log.info((Object)"Checking person permissions ...");
        int count = this.checkandFixPermissions();
        log.info((Object)("... updated " + count));
    }

    private int checkandFixPermissions() {
        Integer count = this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

            @Override
            public Integer execute() throws Exception {
                int count = 0;
                Set<NodeRef> people = CheckAndFixPersonPermissionsBootstrapBean.this.personService.getAllPeople();
                for (NodeRef person : people) {
                    String uid = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)CheckAndFixPersonPermissionsBootstrapBean.this.nodeService.getProperty(person, ContentModel.PROP_USERNAME));
                    if (CheckAndFixPersonPermissionsBootstrapBean.this.excludedUsers != null && CheckAndFixPersonPermissionsBootstrapBean.this.excludedUsers.contains(uid) || CheckAndFixPersonPermissionsBootstrapBean.this.permissionsManager.validatePermissions(person, uid, uid)) continue;
                    CheckAndFixPersonPermissionsBootstrapBean.this.permissionsManager.setPermissions(person, uid, uid);
                    ++count;
                }
                return count;
            }
        });
        return count;
    }

    protected void onShutdown(ApplicationEvent event) {
    }
}

