/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.io.Serializable;

class ProtectedUser
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String userId;
    private long numLogins;
    private long timeStamp;

    ProtectedUser(String userId) {
        this.userId = userId;
        this.numLogins = 1L;
        this.timeStamp = System.currentTimeMillis();
    }

    ProtectedUser(String userId, long numLogins) {
        this.userId = userId;
        this.numLogins = numLogins;
        this.timeStamp = System.currentTimeMillis();
    }

    long getNumLogins() {
        return this.numLogins;
    }

    long getTimeStamp() {
        return this.timeStamp;
    }

    public String toString() {
        return "ProtectedUser{userId='" + this.userId + "', numLogins=" + this.numLogins + ", timeStamp=" + this.timeStamp + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProtectedUser that = (ProtectedUser)o;
        if (this.numLogins != that.numLogins) {
            return false;
        }
        if (this.timeStamp != that.timeStamp) {
            return false;
        }
        return this.userId.equals(that.userId);
    }

    public int hashCode() {
        int result = this.userId.hashCode();
        result = 31 * result + (int)(this.numLogins ^ this.numLogins >>> 32);
        result = 31 * result + (int)(this.timeStamp ^ this.timeStamp >>> 32);
        return result;
    }
}

