/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.db;

import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.search.AbstractResultSet;
import org.alfresco.repo.search.SimpleResultSetMetaData;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBResultSetRow;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBResultSetRowIterator;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.ResultSetMetaData;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;

public class DBResultSet
extends AbstractResultSet {
    private List<Node> nodes;
    private NodeDAO nodeDao;
    private NodeService nodeService;
    private TenantService tenantService;
    private SimpleResultSetMetaData resultSetMetaData;
    private BitSet prefetch;
    private int numberFound;

    public DBResultSet(SearchParameters searchParameters, List<Node> nodes, NodeDAO nodeDao, NodeService nodeService, TenantService tenantService, int maximumResultsFromUnlimitedQuery) {
        LimitBy limitBy;
        this.nodeDao = nodeDao;
        this.nodes = nodes;
        this.nodeService = nodeService;
        this.tenantService = tenantService;
        this.prefetch = new BitSet(nodes.size());
        this.numberFound = nodes.size();
        int maxResults = -1;
        if (searchParameters.getMaxItems() >= 0) {
            maxResults = searchParameters.getMaxItems();
            limitBy = LimitBy.FINAL_SIZE;
        } else if (searchParameters.getLimitBy() == LimitBy.FINAL_SIZE && searchParameters.getLimit() >= 0) {
            maxResults = searchParameters.getLimit();
            limitBy = LimitBy.FINAL_SIZE;
        } else {
            maxResults = searchParameters.getMaxPermissionChecks();
            if (maxResults < 0) {
                maxResults = maximumResultsFromUnlimitedQuery;
            }
            limitBy = LimitBy.NUMBER_OF_PERMISSION_EVALUATIONS;
        }
        this.resultSetMetaData = new SimpleResultSetMetaData(maxResults > 0 && nodes.size() < maxResults ? LimitBy.UNLIMITED : limitBy, PermissionEvaluationMode.EAGER, searchParameters);
    }

    public int length() {
        return this.nodes.size();
    }

    public void setNumberFound(int numFound) {
        this.numberFound = numFound;
    }

    public long getNumberFound() {
        return this.numberFound;
    }

    public NodeRef getNodeRef(int n) {
        NodeRef nodeRef = this.nodes.get(n).getNodeRef();
        nodeRef = this.tenantService.getBaseName(nodeRef);
        return nodeRef;
    }

    public ResultSetRow getRow(int i) {
        return new DBResultSetRow(this, i);
    }

    public ChildAssociationRef getChildAssocRef(int n) {
        ChildAssociationRef primaryParentAssoc = this.nodeService.getPrimaryParent(this.getNodeRef(n));
        if (primaryParentAssoc != null) {
            return primaryParentAssoc;
        }
        return null;
    }

    public ResultSetMetaData getResultSetMetaData() {
        return this.resultSetMetaData;
    }

    public int getStart() {
        return 0;
    }

    public boolean hasMore() {
        return false;
    }

    public Iterator<ResultSetRow> iterator() {
        return new DBResultSetRowIterator(this);
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public Node getNode(int n) {
        return this.nodes.get(n);
    }
}

