/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.util.ListIterator;
import org.alfresco.repo.search.impl.lucene.PagingLuceneResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;

public class PagingLuceneResultSetRowIteratorImpl
implements ListIterator<ResultSetRow> {
    private PagingLuceneResultSet resultSet;
    private int position = -1;
    private int max;

    public PagingLuceneResultSetRowIteratorImpl(PagingLuceneResultSet resultSet) {
        this.resultSet = resultSet;
        this.max = resultSet.getLength();
    }

    public PagingLuceneResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public boolean hasNext() {
        return this.position < this.max - 1;
    }

    public boolean allowsReverse() {
        return true;
    }

    @Override
    public boolean hasPrevious() {
        return this.position > 0;
    }

    @Override
    public ResultSetRow next() {
        return this.resultSet.getRow(this.moveToNextPosition());
    }

    protected int moveToNextPosition() {
        return ++this.position;
    }

    @Override
    public ResultSetRow previous() {
        return this.resultSet.getRow(this.moveToPreviousPosition());
    }

    protected int moveToPreviousPosition() {
        return --this.position;
    }

    @Override
    public int nextIndex() {
        return this.position + 1;
    }

    @Override
    public int previousIndex() {
        return this.position - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(ResultSetRow o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(ResultSetRow o) {
        throw new UnsupportedOperationException();
    }
}

