/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.search.NodeServiceXPath;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.ISO9075;
import org.jaxen.DefaultNavigator;
import org.jaxen.JaxenException;
import org.jaxen.NamedAccessNavigator;
import org.jaxen.UnsupportedAxisException;
import org.jaxen.XPath;

public class DocumentNavigator
extends DefaultNavigator
implements NamedAccessNavigator {
    private static final long serialVersionUID = 3618984485740165427L;
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private SearchService searchService;
    private NamespacePrefixResolver nspr;
    private boolean followAllParentLinks;
    private static final UnsupportedAxisException EXCEPTION_NOT_SUPPORTED = new UnsupportedAxisException("");

    public DocumentNavigator(DictionaryService dictionaryService, NodeService nodeService, SearchService searchService, NamespacePrefixResolver nspr, boolean followAllParentLinks, boolean useJCRRootNode) {
        this(dictionaryService, nodeService, searchService, nspr, followAllParentLinks);
    }

    public DocumentNavigator(DictionaryService dictionaryService, NodeService nodeService, SearchService searchService, NamespacePrefixResolver nspr, boolean followAllParentLinks) {
        this.dictionaryService = dictionaryService;
        this.nodeService = nodeService;
        this.searchService = searchService;
        this.nspr = nspr;
        this.followAllParentLinks = followAllParentLinks;
    }

    public NamespacePrefixResolver getNamespacePrefixResolver() {
        return this.nspr;
    }

    public void setFollowAllParentLinks(boolean followAllParentLinks) {
        this.followAllParentLinks = followAllParentLinks;
    }

    public String getAttributeName(Object o) {
        return ISO9075.encode((String)((Property)o).qname.getLocalName());
    }

    public String getAttributeNamespaceUri(Object o) {
        return ((Property)o).qname.getNamespaceURI();
    }

    public String getAttributeQName(Object o) {
        QName qName = ((Property)o).qname;
        String escapedLocalName = ISO9075.encode((String)qName.getLocalName());
        if (EqualsHelper.nullSafeEquals((Object)escapedLocalName, (Object)qName.getLocalName())) {
            return qName.toString();
        }
        return QName.createQName((String)qName.getNamespaceURI(), (String)escapedLocalName).toString();
    }

    public String getAttributeStringValue(Object o) {
        return (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)((Property)o).value);
    }

    public String getCommentStringValue(Object o) {
        throw new UnsupportedOperationException("Comment string values are unsupported");
    }

    public String getElementName(Object o) {
        QName qName = ((ChildAssociationRef)o).getQName();
        if (qName == null) {
            return "";
        }
        return ISO9075.encode((String)qName.getLocalName());
    }

    public String getElementNamespaceUri(Object o) {
        QName qName = ((ChildAssociationRef)o).getQName();
        if (qName == null) {
            return "";
        }
        return qName.getNamespaceURI();
    }

    public String getElementQName(Object o) {
        QName qName = ((ChildAssociationRef)o).getQName();
        if (qName == null) {
            return "";
        }
        String escapedLocalName = ISO9075.encode((String)qName.getLocalName());
        if (EqualsHelper.nullSafeEquals((Object)escapedLocalName, (Object)qName.getLocalName())) {
            return qName.toString();
        }
        return QName.createQName((String)qName.getNamespaceURI(), (String)escapedLocalName).toString();
    }

    public String getElementStringValue(Object o) {
        throw new UnsupportedOperationException("Element string values are unsupported");
    }

    public String getNamespacePrefix(Object o) {
        return ((Namespace)o).prefix;
    }

    public String getNamespaceStringValue(Object o) {
        return ((Namespace)o).uri;
    }

    public String getTextStringValue(Object o) {
        throw new UnsupportedOperationException("Text nodes are unsupported");
    }

    public boolean isAttribute(Object o) {
        return o instanceof Property;
    }

    public boolean isComment(Object o) {
        return false;
    }

    public boolean isDocument(Object o) {
        if (!(o instanceof ChildAssociationRef)) {
            return false;
        }
        ChildAssociationRef car = (ChildAssociationRef)o;
        return car.getParentRef() == null && car.getQName() == null;
    }

    public boolean isElement(Object o) {
        return o instanceof ChildAssociationRef;
    }

    public boolean isNamespace(Object o) {
        return o instanceof Namespace;
    }

    public boolean isProcessingInstruction(Object o) {
        return false;
    }

    public boolean isText(Object o) {
        return false;
    }

    public XPath parseXPath(String o) throws JaxenException {
        return new NodeServiceXPath(o, this, null);
    }

    public Iterator getAttributeAxisIterator(Object contextNode, String localName, String namespacePrefix, String namespaceURI) throws UnsupportedAxisException {
        localName = ISO9075.decode((String)localName);
        NodeRef nodeRef = ((ChildAssociationRef)contextNode).getChildRef();
        QName qName = QName.createQName((String)namespaceURI, (String)localName);
        Serializable value = this.nodeService.getProperty(nodeRef, qName);
        List<Object> properties = null;
        if (value != null) {
            if (value instanceof Collection) {
                Collection values = (Collection)((Object)value);
                properties = new ArrayList(values.size());
                for (Serializable collectionValue : values) {
                    Property property = new Property(qName, collectionValue, nodeRef);
                    properties.add(property);
                }
            } else {
                Property property = new Property(qName, value, nodeRef);
                properties = Collections.singletonList(property);
            }
        } else {
            properties = Collections.emptyList();
        }
        return properties.iterator();
    }

    public Iterator getAttributeAxisIterator(Object o) throws UnsupportedAxisException {
        ArrayList<Property> properties = new ArrayList<Property>();
        NodeRef nodeRef = ((ChildAssociationRef)o).getChildRef();
        Map map = this.nodeService.getProperties(nodeRef);
        for (QName qName : map.keySet()) {
            if (map.get(qName) instanceof Collection) {
                for (Serializable ob : (Collection)map.get(qName)) {
                    Property property = new Property(qName, ob, nodeRef);
                    properties.add(property);
                }
                continue;
            }
            Property property = new Property(qName, (Serializable)map.get(qName), nodeRef);
            properties.add(property);
        }
        return properties.iterator();
    }

    public Iterator getChildAxisIterator(Object contextNode, String localName, String namespacePrefix, String namespaceURI) throws UnsupportedAxisException {
        if ((localName = ISO9075.decode((String)localName)) != null && (localName.equalsIgnoreCase("true") || localName.equalsIgnoreCase("false"))) {
            return Collections.singletonList(Boolean.parseBoolean(localName)).iterator();
        }
        ChildAssociationRef assocRef = (ChildAssociationRef)contextNode;
        NodeRef childRef = assocRef.getChildRef();
        QName qName = QName.createQName((String)namespaceURI, (String)localName);
        List list = null;
        list = this.nodeService.getChildAssocs(childRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)qName);
        return list.iterator();
    }

    public Iterator getChildAxisIterator(Object o) throws UnsupportedAxisException {
        ChildAssociationRef assocRef = (ChildAssociationRef)o;
        NodeRef childRef = assocRef.getChildRef();
        List list = this.nodeService.getChildAssocs(childRef);
        return list.iterator();
    }

    public Iterator getFollowingSiblingAxisIterator(Object arg0) throws UnsupportedAxisException {
        throw EXCEPTION_NOT_SUPPORTED;
    }

    public Iterator getFollowingAxisIterator(Object arg0) throws UnsupportedAxisException {
        throw EXCEPTION_NOT_SUPPORTED;
    }

    public Iterator getPrecedingAxisIterator(Object arg0) throws UnsupportedAxisException {
        throw EXCEPTION_NOT_SUPPORTED;
    }

    public Iterator getPrecedingSiblingAxisIterator(Object arg0) throws UnsupportedAxisException {
        throw EXCEPTION_NOT_SUPPORTED;
    }

    public Iterator getNamespaceAxisIterator(Object o) throws UnsupportedAxisException {
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        for (String prefix : this.nspr.getPrefixes()) {
            String uri = this.nspr.getNamespaceURI(prefix);
            Namespace ns = new Namespace(prefix, uri);
            namespaces.add(ns);
        }
        return namespaces.iterator();
    }

    public Iterator getParentAxisIterator(Object o) throws UnsupportedAxisException {
        ChildAssociationRef contextRef;
        ArrayList<ChildAssociationRef> parents = new ArrayList<ChildAssociationRef>(1);
        if (o instanceof ChildAssociationRef && (contextRef = (ChildAssociationRef)o).getParentRef() != null) {
            if (this.followAllParentLinks) {
                for (ChildAssociationRef car : this.nodeService.getParentAssocs(contextRef.getChildRef())) {
                    parents.add(this.nodeService.getPrimaryParent(car.getParentRef()));
                }
            } else {
                parents.add(this.nodeService.getPrimaryParent(contextRef.getParentRef()));
            }
        }
        if (o instanceof Property) {
            Property p = (Property)o;
            parents.add(this.nodeService.getPrimaryParent(p.parent));
        }
        return parents.iterator();
    }

    public Object getDocumentNode(Object o) {
        ChildAssociationRef assocRef = (ChildAssociationRef)o;
        StoreRef storeRef = assocRef.getChildRef().getStoreRef();
        return new ChildAssociationRef(null, null, null, this.nodeService.getRootNode(storeRef));
    }

    public Object getNode(NodeRef nodeRef) {
        return this.nodeService.getPrimaryParent(nodeRef);
    }

    public List<ChildAssociationRef> getNode(NodeRef nodeRef, QNamePattern qNamePattern) {
        return this.nodeService.getParentAssocs(nodeRef, RegexQNamePattern.MATCH_ALL, qNamePattern);
    }

    public Boolean like(NodeRef childRef, QName qname, String sqlLikePattern, boolean includeFTS) {
        return this.searchService.like(childRef, qname, sqlLikePattern, includeFTS);
    }

    public Boolean contains(NodeRef childRef, QName qname, String sqlLikePattern, SearchParameters.Operator defaultOperator) {
        return this.searchService.contains(childRef, qname, sqlLikePattern, defaultOperator);
    }

    public Boolean isSubtypeOf(NodeRef nodeRef, QName typeQName) {
        QName nodeTypeQName = this.nodeService.getType(nodeRef);
        return this.dictionaryService.isSubClass(nodeTypeQName, typeQName);
    }

    public Boolean hasAspect(NodeRef nodeRef, QName typeQName) {
        return this.nodeService.hasAspect(nodeRef, typeQName);
    }

    public class Namespace {
        public final String prefix;
        public final String uri;

        public Namespace(String prefix, String uri) {
            this.prefix = prefix;
            this.uri = uri;
        }
    }

    public class Property {
        public final QName qname;
        public final Serializable value;
        public final NodeRef parent;

        public Property(QName qname, Serializable value, NodeRef parent) {
            this.qname = qname;
            this.value = value;
            this.parent = parent;
        }
    }
}

