/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule;

import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.repo.rule.RuntimeRuleService;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;

public class LinkRules
extends ActionExecuterAbstractBase {
    public static final String NAME = "link-rules";
    public static final String PARAM_LINK_FROM_NODE = "link_from_node";
    private NodeService nodeService;
    private RuntimeRuleService ruleService;

    public void setRuleService(RuntimeRuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        if (this.nodeService.exists(actionedUponNodeRef)) {
            NodeRef linkedFromNodeRef = (NodeRef)action.getParameterValue(PARAM_LINK_FROM_NODE);
            if (!this.nodeService.hasAspect(linkedFromNodeRef, RuleModel.ASPECT_RULES)) {
                throw new AlfrescoRuntimeException("The link from node has no rules to link.");
            }
            if (this.nodeService.hasAspect(actionedUponNodeRef, RuleModel.ASPECT_RULES)) {
                NodeRef linkedToNode = ((RuleService)((Object)this.ruleService)).getLinkedToRuleNode(actionedUponNodeRef);
                if (linkedToNode == null) {
                    List<Rule> rules = ((RuleService)((Object)this.ruleService)).getRules(actionedUponNodeRef, false);
                    if (!rules.isEmpty()) {
                        throw new AlfrescoRuntimeException("The current folder has rules and can not be linked to another folder.");
                    }
                    NodeRef ruleFolder = this.ruleService.getSavedRuleFolderAssoc(actionedUponNodeRef).getChildRef();
                    this.nodeService.deleteNode(ruleFolder);
                } else {
                    this.nodeService.removeAspect(actionedUponNodeRef, RuleModel.ASPECT_RULES);
                }
            }
            NodeRef ruleSetNodeRef = this.ruleService.getSavedRuleFolderAssoc(linkedFromNodeRef).getChildRef();
            this.nodeService.addChild(actionedUponNodeRef, ruleSetNodeRef, RuleModel.ASSOC_RULE_FOLDER, RuleModel.ASSOC_RULE_FOLDER);
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_LINK_FROM_NODE, DataTypeDefinition.NODE_REF, true, this.getParamDisplayLabel(PARAM_LINK_FROM_NODE)));
    }
}

