/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.quickshare;

import java.io.Serializable;
import java.util.Date;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.scheduled.SchedulableAction;
import org.alfresco.service.cmr.action.scheduled.ScheduledPersistedAction;
import org.alfresco.service.cmr.quickshare.QuickShareLinkExpiryAction;
import org.alfresco.service.namespace.QName;

public class QuickShareLinkExpiryActionImpl
extends ActionImpl
implements QuickShareLinkExpiryAction {
    public static final String EXECUTOR_NAME = "quickShareLinkExpiryActionExecutor";
    public static final String QUICK_SHARE_LINK_EXPIRY_ACTION_NAME = "quickShareLinkExpiryActionName";
    private static final long serialVersionUID = 2497810872555230797L;
    private ScheduledPersistedAction schedule;

    public QuickShareLinkExpiryActionImpl(String id, String sharedId, String description) {
        super(null, id, EXECUTOR_NAME);
        this.setActionQName(QuickShareLinkExpiryActionImpl.createQName(sharedId));
        this.setDescription(description);
    }

    public QuickShareLinkExpiryActionImpl(Action action) {
        super(action);
    }

    protected void setActionQName(QName actionQName) {
        this.setParameterValue(QUICK_SHARE_LINK_EXPIRY_ACTION_NAME, (Serializable)actionQName);
    }

    @Override
    public QName getActionQName() {
        Serializable parameterValue = this.getParameterValue(QUICK_SHARE_LINK_EXPIRY_ACTION_NAME);
        return (QName)parameterValue;
    }

    @Override
    public ScheduledPersistedAction getSchedule() {
        return this.schedule;
    }

    @Override
    public void setSchedule(ScheduledPersistedAction schedule) {
        this.schedule = schedule;
    }

    @Override
    public String getSharedId() {
        QName qName = this.getActionQName();
        if (qName != null) {
            return qName.getLocalName();
        }
        return null;
    }

    @Override
    public Date getScheduleStart() {
        if (this.schedule == null) {
            return null;
        }
        return this.schedule.getScheduleStart();
    }

    @Override
    public void setScheduleStart(Date startDate) {
        if (this.schedule == null) {
            throw new IllegalStateException("Scheduling is not enabled.");
        }
        this.schedule.setScheduleStart(startDate);
    }

    @Override
    public Integer getScheduleIntervalCount() {
        if (this.schedule == null) {
            return null;
        }
        return this.schedule.getScheduleIntervalCount();
    }

    @Override
    public void setScheduleIntervalCount(Integer count) {
        if (this.schedule == null) {
            throw new IllegalStateException("Scheduling is not enabled.");
        }
        this.schedule.setScheduleIntervalCount(count);
    }

    @Override
    public SchedulableAction.IntervalPeriod getScheduleIntervalPeriod() {
        if (this.schedule == null) {
            return null;
        }
        return this.schedule.getScheduleIntervalPeriod();
    }

    @Override
    public void setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod period) {
        if (this.schedule == null) {
            throw new IllegalStateException("Scheduling is not enabled.");
        }
        this.schedule.setScheduleIntervalPeriod(period);
    }

    public static QName createQName(String sharedId) {
        return QName.createQName(null, (String)sharedId);
    }
}

