/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.io.Serializable;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.search.SearchTrackingComponent;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;

public class CascadeUpdateAspect
implements NodeServicePolicies.OnCreateChildAssociationPolicy,
NodeServicePolicies.OnDeleteChildAssociationPolicy,
NodeServicePolicies.OnMoveNodePolicy {
    private PolicyComponent policyComponent;
    private NodeService nodeService;
    private SearchTrackingComponent searchTrackingComponent;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchTrackingComponent(SearchTrackingComponent searchTrackingComponent) {
        this.searchTrackingComponent = searchTrackingComponent;
    }

    public void init() {
        this.policyComponent.bindAssociationBehaviour(NodeServicePolicies.OnCreateChildAssociationPolicy.QNAME, ContentModel.TYPE_BASE, (Behaviour)new JavaBehaviour(this, "onCreateChildAssociation", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.policyComponent.bindAssociationBehaviour(NodeServicePolicies.OnDeleteChildAssociationPolicy.QNAME, ContentModel.TYPE_BASE, (Behaviour)new JavaBehaviour(this, "onDeleteChildAssociation", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnMoveNodePolicy.QNAME, ContentModel.TYPE_BASE, (Behaviour)new JavaBehaviour(this, "onMoveNode", Behaviour.NotificationFrequency.EVERY_EVENT));
    }

    @Override
    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        this.markCascadeUpdate(oldChildAssocRef.getChildRef());
        this.markCascadeUpdate(newChildAssocRef.getChildRef());
    }

    @Override
    public void onDeleteChildAssociation(ChildAssociationRef childAssocRef) {
        this.markCascadeUpdate(childAssocRef.getChildRef());
    }

    @Override
    public void onCreateChildAssociation(ChildAssociationRef childAssocRef, boolean isNewNode) {
        if (!isNewNode) {
            this.markCascadeUpdate(childAssocRef.getChildRef());
        }
    }

    private void markCascadeUpdate(NodeRef nodeRef) {
        NodeRef.Status status = this.nodeService.getNodeStatus(nodeRef);
        this.nodeService.setProperty(status.getNodeRef(), ContentModel.PROP_CASCADE_CRC, (Serializable)Long.valueOf(this.searchTrackingComponent.getCRC(status.getDbId())));
        this.nodeService.setProperty(status.getNodeRef(), ContentModel.PROP_CASCADE_TX, (Serializable)status.getDbTxnId());
    }
}

