/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.namespace.QName;

public class CategoryTemplateNode
extends TemplateNode {
    public CategoryTemplateNode(NodeRef nodeRef, ServiceRegistry services, TemplateImageResolver resolver) {
        super(nodeRef, services, resolver);
    }

    @Override
    public boolean getIsCategory() {
        return true;
    }

    public List<TemplateNode> getCategoryMembers() {
        if (this.getIsCategory()) {
            return this.buildTemplateNodeList(this.services.getCategoryService().getChildren(this.getNodeRef(), CategoryService.Mode.MEMBERS, CategoryService.Depth.ANY));
        }
        return Collections.emptyList();
    }

    public List<CategoryTemplateNode> getSubCategories() {
        if (this.getIsCategory()) {
            return this.buildCategoryNodeList(this.services.getCategoryService().getChildren(this.getNodeRef(), CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.ANY));
        }
        return Collections.emptyList();
    }

    public List<TemplateNode> getMembersAndSubCategories() {
        if (this.getIsCategory()) {
            return this.buildMixedNodeList(this.services.getCategoryService().getChildren(this.getNodeRef(), CategoryService.Mode.ALL, CategoryService.Depth.ANY));
        }
        return Collections.emptyList();
    }

    public List<TemplateNode> getImmediateCategoryMembers() {
        if (this.getIsCategory()) {
            return this.buildTemplateNodeList(this.services.getCategoryService().getChildren(this.getNodeRef(), CategoryService.Mode.MEMBERS, CategoryService.Depth.IMMEDIATE));
        }
        return Collections.emptyList();
    }

    public List<CategoryTemplateNode> getImmediateSubCategories() {
        if (this.getIsCategory()) {
            return this.buildCategoryNodeList(this.services.getCategoryService().getChildren(this.getNodeRef(), CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.IMMEDIATE));
        }
        return Collections.emptyList();
    }

    public List<TemplateNode> getImmediateMembersAndSubCategories() {
        if (this.getIsCategory()) {
            return this.buildMixedNodeList(this.services.getCategoryService().getChildren(this.getNodeRef(), CategoryService.Mode.ALL, CategoryService.Depth.IMMEDIATE));
        }
        return Collections.emptyList();
    }

    private List<TemplateNode> buildTemplateNodeList(Collection<ChildAssociationRef> childRefs) {
        ArrayList<TemplateNode> answer = new ArrayList<TemplateNode>(childRefs.size());
        for (ChildAssociationRef ref : childRefs) {
            TemplateNode child = new TemplateNode(ref.getChildRef(), this.services, this.imageResolver);
            answer.add(child);
        }
        return answer;
    }

    private List<CategoryTemplateNode> buildCategoryNodeList(Collection<ChildAssociationRef> childRefs) {
        ArrayList<CategoryTemplateNode> answer = new ArrayList<CategoryTemplateNode>(childRefs.size());
        for (ChildAssociationRef ref : childRefs) {
            CategoryTemplateNode child = new CategoryTemplateNode(ref.getChildRef(), this.services, this.imageResolver);
            answer.add(child);
        }
        return answer;
    }

    private List<TemplateNode> buildMixedNodeList(Collection<ChildAssociationRef> cars) {
        ArrayList<TemplateNode> nodes = new ArrayList<TemplateNode>(cars.size());
        for (ChildAssociationRef car : cars) {
            QName type = this.services.getNodeService().getType(car.getChildRef());
            if (this.services.getDictionaryService().isSubClass(type, ContentModel.TYPE_CATEGORY)) {
                nodes.add(new CategoryTemplateNode(car.getChildRef(), this.services, this.imageResolver));
                continue;
            }
            nodes.add(new TemplateNode(car.getChildRef(), this.services, this.imageResolver));
        }
        return nodes;
    }
}

