/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.io.Serializable;
import org.alfresco.repo.jscript.Scopeable;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.jscript.ValueConverter;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.namespace.QName;
import org.mozilla.javascript.Scriptable;
import org.springframework.extensions.surf.util.ParameterCheck;

public class Association
implements Scopeable,
Serializable {
    private static final long serialVersionUID = 897788515655487131L;
    private ServiceRegistry services;
    private Scriptable scope;
    private AssociationRef assocRef;

    public Association(ServiceRegistry services, AssociationRef assocRef) {
        this(services, assocRef, null);
    }

    public Association(ServiceRegistry services, AssociationRef assocRef, Scriptable scope) {
        ParameterCheck.mandatory((String)"Service registry", (Object)services);
        ParameterCheck.mandatory((String)"Association reference", (Object)assocRef);
        this.services = services;
        this.assocRef = assocRef;
        if (scope != null) {
            this.scope = scope;
        }
    }

    @Override
    public void setScope(Scriptable scope) {
        this.scope = scope;
    }

    public AssociationRef getAssociationRef() {
        return this.assocRef;
    }

    public String getType() {
        return this.assocRef.getTypeQName().toString();
    }

    public QName getTypeQName() {
        return this.assocRef.getTypeQName();
    }

    public ScriptNode getSource() {
        return (ScriptNode)((Object)new ValueConverter().convertValueForScript(this.services, this.scope, null, (Serializable)this.assocRef.getSourceRef()));
    }

    public ScriptNode getTarget() {
        return (ScriptNode)((Object)new ValueConverter().convertValueForScript(this.services, this.scope, null, (Serializable)this.assocRef.getTargetRef()));
    }
}

