/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer.system;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.alfresco.repo.admin.patch.AppliedPatch;
import org.alfresco.repo.domain.patch.AppliedPatchDAO;
import org.alfresco.repo.importer.system.PatchInfo;
import org.alfresco.repo.importer.system.SystemInfo;
import org.alfresco.service.cmr.repository.NodeService;

public class SystemExporterImporter {
    private NodeService nodeService;
    private AppliedPatchDAO appliedPatchDAO;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setAppliedPatchDAO(AppliedPatchDAO appliedPatchDAO) {
        this.appliedPatchDAO = appliedPatchDAO;
    }

    public void exportSystem(OutputStream exportStream) {
        SystemInfo systemInfo = new SystemInfo();
        List<AppliedPatch> patches = this.appliedPatchDAO.getAppliedPatches();
        for (AppliedPatch patch : patches) {
            PatchInfo patchInfo = new PatchInfo();
            patchInfo.appliedOnDate = patch.getAppliedOnDate();
            patchInfo.appliedToSchema = patch.getAppliedToSchema();
            patchInfo.appliedToServer = patch.getAppliedToServer();
            patchInfo.description = patch.getDescription();
            patchInfo.fixesFromSchema = patch.getFixesFromSchema();
            patchInfo.fixesToSchema = patch.getFixesToSchema();
            patchInfo.id = patch.getId();
            patchInfo.report = patch.getReport();
            patchInfo.succeeded = patch.getSucceeded();
            patchInfo.targetSchema = patch.getTargetSchema();
            patchInfo.wasExecuted = patch.getWasExecuted();
            systemInfo.patches.add(patchInfo);
        }
        systemInfo.toXML(exportStream);
    }

    public void importSystem(InputStream importStream) {
        SystemInfo systemInfo = SystemInfo.createSystemInfo(importStream);
        for (PatchInfo patchInfo : systemInfo.patches) {
            AppliedPatch patch = new AppliedPatch();
            patch.setId(patchInfo.id);
            patch.setAppliedOnDate(patchInfo.appliedOnDate);
            patch.setAppliedToSchema(patchInfo.appliedToSchema);
            patch.setAppliedToServer(patchInfo.appliedToServer);
            patch.setDescription(patchInfo.description);
            patch.setFixesFromSchema(patchInfo.fixesFromSchema);
            patch.setFixesToSchema(patchInfo.fixesToSchema);
            patch.setReport(patchInfo.report);
            patch.setSucceeded(patchInfo.succeeded);
            patch.setTargetSchema(patchInfo.targetSchema);
            patch.setWasExecuted(patchInfo.wasExecuted);
            this.appliedPatchDAO.createAppliedPatch(patch);
        }
    }
}

