/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import java.lang.reflect.Method;
import org.alfresco.repo.imap.AlfrescoImapFolder;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlfrescoImapFolderAccessInterceptor
implements MethodInterceptor {
    private Log logger = LogFactory.getLog(AlfrescoImapFolderAccessInterceptor.class);
    private PermissionService permissionService;

    public Object invoke(MethodInvocation mi) throws Throwable {
        Object[] args = mi.getArguments();
        Method method = mi.getMethod();
        String methodName = method.getName();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Check the cache [" + methodName + "]"));
        }
        if ("contains".equals(methodName)) {
            String mailboxName = (String)args[0];
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Check the cache [" + methodName + "] for '" + mailboxName + "'"));
            }
            boolean containsResult = (Boolean)mi.proceed();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("The cache " + (containsResult ? "contains" : "does't contain") + " '" + mailboxName + "'"));
            }
            return containsResult;
        }
        if ("get".equals(methodName)) {
            String mailboxName = (String)args[0];
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Check the cache [" + methodName + "] for '" + mailboxName + "'"));
            }
            AlfrescoImapFolder folder = (AlfrescoImapFolder)mi.proceed();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("The cache " + (folder != null ? "contains" : "does't contain") + " '" + mailboxName + "'"));
            }
            if (folder != null) {
                boolean accessAllowed;
                NodeRef nodeRef = folder.getFolderInfo().getNodeRef();
                boolean bl = accessAllowed = this.permissionService.hasPermission(nodeRef, "Read") == AccessStatus.ALLOWED && this.permissionService.hasPermission(nodeRef, "ReadChildren") == AccessStatus.ALLOWED;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Access " + (accessAllowed ? "allowed" : "denied") + " to '" + mailboxName + "' for user '" + AuthenticationUtil.getFullyAuthenticatedUser() + "'"));
                }
                if (!accessAllowed) {
                    return null;
                }
            }
            return folder;
        }
        return mi.proceed();
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }
}

