/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.workflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.repo.forms.processor.node.ContentModelItemData;
import org.alfresco.repo.forms.processor.node.PropertyFieldProcessor;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.springframework.util.StringUtils;

public class ExtendedPropertyFieldProcessor
extends PropertyFieldProcessor {
    private Set<QName> escapedPropertyNames = new HashSet<QName>();
    private Set<String> escapedFieldNames = new HashSet<String>();

    @Override
    public Object getValue(QName name, ContentModelItemData<?> data) {
        List list;
        Serializable value = data.getPropertyValue(name);
        if (value != null && value instanceof List && !(list = (List)((Object)value)).isEmpty() && list.get(0) instanceof String) {
            ArrayList<String> escapedValues = new ArrayList<String>(list.size());
            for (Object listValue : list) {
                escapedValues.add(this.escape((String)listValue));
            }
            return StringUtils.collectionToCommaDelimitedString(escapedValues);
        }
        return super.getValue(name, data);
    }

    public boolean isApplicableForProperty(QName propName) {
        return this.escapedPropertyNames != null && this.escapedPropertyNames.contains(propName);
    }

    public boolean isApplicableForField(String fieldName) {
        return this.escapedFieldNames != null && this.escapedFieldNames.contains(fieldName);
    }

    public void addEscapedPropertyName(QName name) {
        this.escapedPropertyNames.add(name);
        this.escapedFieldNames.add(name.toPrefixString());
    }

    @Override
    protected QName getFullName(String name) {
        String[] parts = name.split(":");
        if (parts.length == 2) {
            String prefix = parts[0];
            String localName = parts[1];
            return QName.createQName((String)prefix, (String)localName, (NamespacePrefixResolver)this.namespaceService);
        }
        String prefix = parts[1];
        String localName = parts[2];
        return QName.createQName((String)prefix, (String)localName, (NamespacePrefixResolver)this.namespaceService);
    }

    protected String escape(String listValue) {
        if (listValue.indexOf(92) > 0) {
            listValue = listValue.replace("\\", "\\\\");
        }
        if (listValue.indexOf(44) > 0) {
            listValue = listValue.replace(",", "\\,");
        }
        return listValue;
    }

    public static void main(String[] args) {
        ExtendedPropertyFieldProcessor processor = new ExtendedPropertyFieldProcessor();
        processor.addEscapedPropertyName(WorkflowModel.PROP_COMMENT);
        System.out.println(processor.getFullName("prop:cm:content"));
    }
}

