/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.workflow;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.forms.Field;
import org.alfresco.repo.forms.Form;
import org.alfresco.repo.forms.FormData;
import org.alfresco.repo.forms.FormNotFoundException;
import org.alfresco.repo.forms.Item;
import org.alfresco.repo.forms.processor.FormCreationData;
import org.alfresco.repo.forms.processor.node.ContentModelFormProcessor;
import org.alfresco.repo.forms.processor.node.ContentModelItemData;
import org.alfresco.repo.forms.processor.workflow.ContentModelFormPersister;
import org.alfresco.repo.forms.processor.workflow.ExtendedFieldBuilder;
import org.alfresco.repo.forms.processor.workflow.ExtendedPropertyFieldProcessor;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.util.ParameterCheck;

public abstract class AbstractWorkflowFormProcessor<ItemType, PersistType>
extends ContentModelFormProcessor<ItemType, PersistType> {
    protected WorkflowService workflowService;
    protected BehaviourFilter behaviourFilter;
    private ExtendedPropertyFieldProcessor extendedPropertyFieldProcessor;

    @Override
    protected void populateForm(Form form, List<String> fields, FormCreationData data) {
        super.populateForm(form, fields, data);
        ContentModelItemData itemData = (ContentModelItemData)data.getItemData();
        this.addPropertyDataIfRequired(WorkflowModel.PROP_PACKAGE_ACTION_GROUP, form, itemData);
        this.addPropertyDataIfRequired(WorkflowModel.PROP_PACKAGE_ITEM_ACTION_GROUP, form, itemData);
    }

    @Override
    protected PersistType internalPersist(ItemType item, FormData data) {
        ContentModelFormPersister<PersistType> persister = this.makeFormPersister(item);
        for (FormData.FieldData fieldData : data) {
            persister.addField(fieldData);
        }
        return persister.persist();
    }

    @Override
    protected List<Field> generateDefaultFields(FormCreationData data, List<String> fieldsToIgnore) {
        if (this.extendedPropertyFieldProcessor != null) {
            ExtendedFieldBuilder fieldBuilder = new ExtendedFieldBuilder(data, this.fieldProcessorRegistry, this.namespaceService, fieldsToIgnore, this.extendedPropertyFieldProcessor);
            return fieldBuilder.buildDefaultFields();
        }
        return super.generateDefaultFields(data, fieldsToIgnore);
    }

    @Override
    protected List<Field> generateSelectedFields(List<String> fields, FormCreationData data) {
        if (this.extendedPropertyFieldProcessor != null) {
            ArrayList<Field> fieldData = new ArrayList<Field>(fields.size());
            for (String fieldName : fields) {
                Field field = null;
                field = this.extendedPropertyFieldProcessor.isApplicableForField(fieldName) ? this.extendedPropertyFieldProcessor.generateField(fieldName, data) : this.fieldProcessorRegistry.buildField(fieldName, data);
                if (field == null) {
                    if (!this.getLogger().isDebugEnabled()) continue;
                    String msg = "Ignoring unrecognised field \"" + fieldName + "\"";
                    this.getLogger().debug((Object)msg);
                    continue;
                }
                fieldData.add(field);
            }
            return fieldData;
        }
        return super.generateSelectedFields(fields, data);
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setExtendedPropertyFieldProcessor(ExtendedPropertyFieldProcessor extendedPropertyFieldProcessor) {
        this.extendedPropertyFieldProcessor = extendedPropertyFieldProcessor;
    }

    @Override
    protected ItemType getTypedItem(Item item) {
        try {
            ParameterCheck.mandatory((String)"item", (Object)item);
            return this.getTypedItemForDecodedId(item.getId());
        }
        catch (AccessDeniedException ade) {
            throw ade;
        }
        catch (Exception e) {
            throw new FormNotFoundException(item, e);
        }
    }

    @Override
    protected List<String> getDefaultIgnoredFields() {
        List<String> fields = super.getDefaultIgnoredFields();
        if (fields == null) {
            fields = new ArrayList<String>(20);
        }
        fields.add("cm:name");
        fields.add("cm:owner");
        fields.add("cm:creator");
        fields.add("cm:modifier");
        fields.add("cm:content");
        fields.add("cm:accessed");
        fields.add("cm:modified");
        fields.add("cm:created");
        fields.add("bpm:package");
        fields.add("bpm:pooledActors");
        fields.add("bpm:completedItems");
        fields.add("bpm:completionDate");
        fields.add("bpm:context");
        fields.add("bpm:hiddenTransitions");
        fields.add("bpm:reassignable");
        fields.add("bpm:startDate");
        fields.add("bpm:packageActionGroup");
        fields.add("bpm:packageItemActionGroup");
        fields.add("bpm:outcome");
        fields.add("bpm:taskId");
        return fields;
    }

    protected abstract ContentModelFormPersister<PersistType> makeFormPersister(ItemType var1);

    protected abstract ItemType getTypedItemForDecodedId(String var1);
}

