/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.node;

import org.alfresco.repo.forms.Field;
import org.alfresco.repo.forms.FieldGroup;
import org.alfresco.repo.forms.processor.node.AssociationFieldProcessor;
import org.alfresco.repo.forms.processor.node.ContentModelItemData;
import org.alfresco.repo.forms.processor.node.PropertyFieldProcessor;
import org.alfresco.repo.forms.processor.node.QNameFieldProcessor;
import org.alfresco.service.cmr.dictionary.ClassAttributeDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class DefaultFieldProcessor
extends QNameFieldProcessor<ClassAttributeDefinition>
implements InitializingBean {
    private static final Log logger = LogFactory.getLog(DefaultFieldProcessor.class);
    private final AssociationFieldProcessor assocProcessor = new AssociationFieldProcessor();
    private final PropertyFieldProcessor propProcessor = new PropertyFieldProcessor();

    @Override
    protected Log getLogger() {
        return logger;
    }

    @Override
    protected QName getFullName(String name) {
        String[] parts = name.split(":");
        int position = parts.length - 1;
        String localName = parts[position];
        String prefix = parts[--position];
        return QName.createQName((String)prefix, (String)localName, (NamespacePrefixResolver)this.namespaceService);
    }

    @Override
    public Field generateField(QName fullName, ContentModelItemData<?> itemData, boolean isForcedField) {
        Field fieldInfo = this.propProcessor.generateField(fullName, itemData, isForcedField);
        if (fieldInfo == null) {
            fieldInfo = this.assocProcessor.generateField(fullName, itemData, isForcedField);
        }
        return fieldInfo;
    }

    @Override
    protected String getRegistryKey() {
        return "";
    }

    public void afterPropertiesSet() throws Exception {
        ParameterCheck.mandatory((String)"dictionaryService", (Object)this.dictionaryService);
        ParameterCheck.mandatory((String)"namespaceService", (Object)this.namespaceService);
        this.assocProcessor.setDictionaryService(this.dictionaryService);
        this.assocProcessor.setNamespaceService(this.namespaceService);
        this.propProcessor.setDictionaryService(this.dictionaryService);
        this.propProcessor.setNamespaceService(this.namespaceService);
    }

    @Override
    protected FieldGroup getGroup(ClassAttributeDefinition typeDef) {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    @Override
    protected ClassAttributeDefinition getTypeDefinition(QName fullName, ContentModelItemData<?> itemData, boolean isForcedField) {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    @Override
    protected Object getValue(QName fullName, ContentModelItemData<?> itemData) {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    @Override
    protected Field makeField(ClassAttributeDefinition typeDef, Object value, FieldGroup group) {
        throw new UnsupportedOperationException("This method should never be called!");
    }
}

