/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import java.util.ArrayDeque;
import java.util.Deque;
import org.alfresco.repo.event.v1.model.DataAttributes;
import org.alfresco.repo.event.v1.model.EventData;
import org.alfresco.repo.event.v1.model.EventType;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.alfresco.repo.event.v1.model.Resource;
import org.alfresco.repo.event2.EventInfo;
import org.alfresco.repo.event2.EventJSONSchema;
import org.alfresco.repo.event2.NodeResourceHelper;
import org.alfresco.service.cmr.repository.EntityRef;
import org.alfresco.service.namespace.QName;

public abstract class EventConsolidator<REF extends EntityRef, RES extends Resource> {
    protected final Deque<EventType> eventTypes = new ArrayDeque<EventType>();
    protected final NodeResourceHelper helper;
    protected REF entityReference;
    protected RES resource;

    public EventConsolidator(REF entityReference, NodeResourceHelper nodeResourceHelper) {
        this.entityReference = entityReference;
        this.helper = nodeResourceHelper;
    }

    public abstract QName getEntityType();

    public abstract boolean isTemporaryEntity();

    protected abstract EventType getDerivedEvent();

    public Deque<EventType> getEventTypes() {
        return this.eventTypes;
    }

    public RepoEvent<DataAttributes<RES>> getRepoEvent(EventInfo eventInfo) {
        RepoEvent.Builder builder = RepoEvent.builder();
        this.configureRepoEventBuilder(builder, eventInfo);
        return builder.build();
    }

    protected void configureRepoEventBuilder(RepoEvent.Builder<DataAttributes<RES>> builder, EventInfo eventInfo) {
        EventType eventType = this.getDerivedEvent();
        DataAttributes<RES> eventData = this.buildEventData(eventInfo, this.resource, eventType);
        builder.setId(eventInfo.getId()).setSource(eventInfo.getSource()).setTime(eventInfo.getTimestamp()).setType(eventType.getType()).setData(eventData).setDataschema(EventJSONSchema.getSchemaV1(eventType));
    }

    protected DataAttributes<RES> buildEventData(EventInfo eventInfo, RES resource, EventType eventType) {
        return EventData.builder().setEventGroupId(eventInfo.getTxnId()).setResource(resource).build();
    }
}

