/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.node;

import java.io.Serializable;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ParameterCheck;

class ChildByNameKey
implements Serializable {
    private static final long serialVersionUID = -2167221525380802365L;
    private final Long parentNodeId;
    private QName assocTypeQName;
    private String childNodeName;

    ChildByNameKey(Long parentNodeId, QName assocTypeQName, String childNodeName) {
        ParameterCheck.mandatory((String)"childNodeName", (Object)childNodeName);
        ParameterCheck.mandatory((String)"assocTypeQName", (Object)assocTypeQName);
        ParameterCheck.mandatory((String)"parentNodeId", (Object)parentNodeId);
        this.parentNodeId = parentNodeId;
        this.assocTypeQName = assocTypeQName;
        this.childNodeName = childNodeName;
    }

    public Long getParentNodeId() {
        return this.parentNodeId;
    }

    public QName getAssocTypeQName() {
        return this.assocTypeQName;
    }

    public String getChildNodeName() {
        return this.childNodeName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChildByNameKey)) {
            return false;
        }
        ChildByNameKey o = (ChildByNameKey)other;
        return this.parentNodeId.equals(o.getParentNodeId()) && this.assocTypeQName.equals((Object)o.getAssocTypeQName()) && this.childNodeName.equalsIgnoreCase(o.getChildNodeName());
    }

    public int hashCode() {
        return this.parentNodeId.hashCode() + this.assocTypeQName.hashCode() + this.childNodeName.toLowerCase().hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ChildByNameInfo ").append("[parentNodeId=").append(this.parentNodeId).append(", assocTypeQName=").append(this.assocTypeQName).append(", childNodeName=").append(this.childNodeName).append("]");
        return builder.toString();
    }
}

