/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary.types.period;

import java.util.Calendar;
import org.alfresco.repo.dictionary.types.period.AbstractEndOfCalendarPeriodProvider;

public class EndOfQuarter
extends AbstractEndOfCalendarPeriodProvider {
    public static final String PERIOD_TYPE = "quarterend";

    @Override
    public void add(Calendar calendar, int value) {
        if (value > 0) {
            calendar.add(14, 1);
        }
        int dayOfMonth = calendar.get(5);
        int month = calendar.get(2);
        int monthInYear = month - this.getStartMonth();
        if (monthInYear < 0) {
            monthInYear += 12;
        }
        int residualMonths = monthInYear % 3;
        if (dayOfMonth < this.getStartDayOfMonth() && residualMonths == 0) {
            calendar.add(2, (value - 1) * 3);
        } else {
            calendar.add(2, value * 3);
        }
        calendar.add(2, -residualMonths);
        calendar.set(5, this.getStartDayOfMonth());
        calendar.add(6, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
    }

    public String getPeriodType() {
        return PERIOD_TYPE;
    }
}

