/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.text.SimpleDateFormat;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.repo.content.transform.LogEntries;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.util.LogAdapter;

@AlfrescoPublicApi
abstract class TransformerLogger<T>
extends LogAdapter
implements LogEntries {
    static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("d MMM yyyy HH:mm:ss");
    private TransformerDebug transformerDebug;
    private Properties properties;
    private int maxEntries = -1;
    private Deque<T> entries = new LinkedList<T>();

    TransformerLogger() {
        super(null);
    }

    public void setTransformerDebug(TransformerDebug transformerDebug) {
        this.transformerDebug = transformerDebug;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    private int getProperty(String propertyName, int min, int max) {
        int i = 0;
        String value = this.properties.getProperty(propertyName);
        if (value != null) {
            try {
                i = Integer.parseInt(value);
                if (i < 0) {
                    i = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                i = 0;
            }
        }
        i = Math.min(Math.max(i, min), max);
        return i;
    }

    private int getMaxEntries() {
        if (this.maxEntries < 0) {
            this.maxEntries = this.getProperty(this.getPropertyName(), 0, this.getUpperMaxEntries());
        }
        return this.maxEntries;
    }

    public boolean isDebugEnabled() {
        return this.getMaxEntries() > 0 && this.transformerDebug.getStringBuilder() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(Object message, Throwable throwable) {
        if (this.isDebugEnabled()) {
            Deque<T> deque = this.entries;
            synchronized (deque) {
                this.addOrModify(this.entries, message);
                int size = this.entries.size();
                while (size > this.maxEntries) {
                    this.remove(this.entries);
                    --size;
                }
            }
        }
    }

    protected abstract void addOrModify(Deque<T> var1, Object var2);

    protected void remove(Deque<T> entries) {
        entries.removeFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getEntries(int n) {
        if (this.getMaxEntries() > 0) {
            n = n <= 0 ? Integer.MAX_VALUE : n;
            Deque<T> deque = this.entries;
            synchronized (deque) {
                n = Math.min(Math.max(Math.min(this.maxEntries, n), 0), this.entries.size());
                String[] array = new String[n];
                Iterator<T> iterator = this.entries.descendingIterator();
                int i = 0;
                while (i < n) {
                    array[i] = iterator.next().toString();
                    ++i;
                }
                return array;
            }
        }
        return new String[]{"No entries are available. " + this.getPropertyName() + " must be set to a number between 1 and " + this.getUpperMaxEntries()};
    }

    private static void appendProperty(StringBuilder sb, String propertyName, String value, String defaultValue) {
        boolean isDefaultValue = value.equals(defaultValue);
        if (isDefaultValue) {
            sb.append("# ");
        }
        sb.append(propertyName);
        sb.append('=');
        sb.append(value);
        if (!isDefaultValue) {
            sb.append("  # default=");
            sb.append(defaultValue);
        }
    }

    protected abstract int getUpperMaxEntries();

    protected abstract String getPropertyName();
}

