/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.repo.content.metadata.AbstractMappingMetadataExtracter;
import org.alfresco.repo.content.metadata.AsynchronousExtractor;
import org.alfresco.repo.content.metadata.MetadataEmbedder;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@AlfrescoPublicApi
public class MetadataExtracterRegistry {
    private static final Log logger = LogFactory.getLog(MetadataExtracterRegistry.class);
    private List<MetadataExtracter> extracters = new ArrayList<MetadataExtracter>(11);
    private Map<String, List<MetadataExtracter>> extracterCache = new HashMap<String, List<MetadataExtracter>>(18);
    private Map<String, List<MetadataEmbedder>> embedderCache = new HashMap<String, List<MetadataEmbedder>>(18);
    private AsynchronousExtractor asynchronousExtractor;
    private Lock extracterCacheReadLock;
    private Lock extracterCacheWriteLock;
    private boolean asyncExtractEnabled = true;
    private boolean asyncEmbedEnabled = true;

    public MetadataExtracterRegistry() {
        ReentrantReadWriteLock extractionCacheLock = new ReentrantReadWriteLock();
        this.extracterCacheReadLock = extractionCacheLock.readLock();
        this.extracterCacheWriteLock = extractionCacheLock.writeLock();
    }

    public void resetCache() {
        this.extracterCacheWriteLock.lock();
        try {
            this.extracterCache.clear();
            this.embedderCache.clear();
        }
        finally {
            this.extracterCacheWriteLock.unlock();
        }
    }

    public void register(MetadataExtracter extracter) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering metadata extracter: " + String.valueOf(extracter)));
        }
        this.extracterCacheWriteLock.lock();
        try {
            if (extracter instanceof AsynchronousExtractor) {
                this.asynchronousExtractor = (AsynchronousExtractor)extracter;
            } else {
                this.extracters.add(extracter);
            }
            this.extracterCache.clear();
            this.embedderCache.clear();
        }
        finally {
            this.extracterCacheWriteLock.unlock();
        }
    }

    public void setAsyncExtractEnabled(boolean asyncExtractEnabled) {
        this.asyncExtractEnabled = asyncExtractEnabled;
    }

    public void setAsyncEmbedEnabled(boolean asyncEmbedEnabled) {
        this.asyncEmbedEnabled = asyncEmbedEnabled;
    }

    public MetadataExtracter getExtractor(String sourceMimetype, long sourceSizeInBytes) {
        return this.asyncExtractEnabled && this.asynchronousExtractor != null && this.asynchronousExtractor.isSupported(sourceMimetype, sourceSizeInBytes) ? this.asynchronousExtractor : this.getExtracter(sourceMimetype);
    }

    public MetadataExtracter getExtracter(String sourceMimetype) {
        logger.debug((Object)("Get extractors for " + sourceMimetype));
        List<MetadataExtracter> extractors = null;
        this.extracterCacheReadLock.lock();
        try {
            if (this.extracterCache.containsKey(sourceMimetype)) {
                extractors = this.extracterCache.get(sourceMimetype);
            }
        }
        finally {
            this.extracterCacheReadLock.unlock();
        }
        if (extractors == null) {
            this.extracterCacheWriteLock.lock();
            try {
                extractors = this.findBestExtracters(sourceMimetype);
                this.extracterCache.put(sourceMimetype, extractors);
            }
            finally {
                this.extracterCacheWriteLock.unlock();
            }
        }
        MetadataExtracter liveExtractor = null;
        for (MetadataExtracter extractor : extractors) {
            if (!extractor.isSupported(sourceMimetype)) {
                logger.debug((Object)("Get unsupported: " + this.getName(extractor)));
                continue;
            }
            logger.debug((Object)("Get supported:   " + this.getName(extractor)));
            liveExtractor = extractor;
        }
        logger.debug((Object)("Get returning:   " + this.getName(liveExtractor)));
        return liveExtractor;
    }

    private String getName(MetadataExtracter extractor) {
        if (extractor == null) {
            return null;
        }
        if (extractor instanceof AbstractMappingMetadataExtracter) {
            return ((AbstractMappingMetadataExtracter)extractor).getBeanName();
        }
        return extractor.getClass().getSimpleName();
    }

    private List<MetadataExtracter> findBestExtracters(String sourceMimetype) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Finding extractors for " + sourceMimetype));
        }
        ArrayList<MetadataExtracter> extractors = new ArrayList<MetadataExtracter>(1);
        for (MetadataExtracter extractor : this.extracters) {
            if (!extractor.isSupported(sourceMimetype)) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Find unsupported: " + this.getName(extractor)));
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Find supported:   " + this.getName(extractor)));
            }
            extractors.add(extractor);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Find returning:   " + String.valueOf(extractors)));
        }
        return extractors;
    }

    public MetadataEmbedder getEmbedder(String sourceMimetype, long sourceSizeInBytes) {
        return this.asyncEmbedEnabled && this.asynchronousExtractor != null && this.asynchronousExtractor.isEmbedderSupported(sourceMimetype, sourceSizeInBytes) ? this.asynchronousExtractor : this.getEmbedder(sourceMimetype);
    }

    public MetadataEmbedder getEmbedder(String sourceMimetype) {
        List<MetadataEmbedder> embedders = null;
        this.extracterCacheReadLock.lock();
        try {
            if (this.embedderCache.containsKey(sourceMimetype)) {
                embedders = this.embedderCache.get(sourceMimetype);
            }
        }
        finally {
            this.extracterCacheReadLock.unlock();
        }
        if (embedders == null) {
            this.extracterCacheWriteLock.lock();
            try {
                embedders = this.findBestEmbedders(sourceMimetype);
                this.embedderCache.put(sourceMimetype, embedders);
            }
            finally {
                this.extracterCacheWriteLock.unlock();
            }
        }
        MetadataEmbedder liveEmbedder = null;
        for (MetadataEmbedder embedder : embedders) {
            if (!embedder.isEmbeddingSupported(sourceMimetype)) continue;
            liveEmbedder = embedder;
        }
        return liveEmbedder;
    }

    private List<MetadataEmbedder> findBestEmbedders(String sourceMimetype) {
        logger.debug((Object)("Finding embedders for " + sourceMimetype));
        ArrayList<MetadataEmbedder> embedders = new ArrayList<MetadataEmbedder>(1);
        for (MetadataExtracter extractor : this.extracters) {
            if (!(extractor instanceof MetadataEmbedder) || !((MetadataEmbedder)((Object)extractor)).isEmbeddingSupported(sourceMimetype)) continue;
            embedders.add((MetadataEmbedder)((Object)extractor));
        }
        return embedders;
    }
}

