/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Locale;
import org.alfresco.repo.content.AbstractStreamAwareProxy;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentStreamListener;

public class StreamAwareContentReaderProxy
extends AbstractStreamAwareProxy
implements ContentReader {
    private ContentReader delegatee;
    private Closeable releaseableResource;

    public StreamAwareContentReaderProxy(ContentReader delegator) {
        this.delegatee = delegator;
    }

    public boolean exists() {
        return this.delegatee.exists();
    }

    public void getContent(OutputStream os) throws ContentIOException {
        this.delegatee.getContent(os);
    }

    public void getContent(File file) throws ContentIOException {
        this.delegatee.getContent(file);
    }

    public InputStream getContentInputStream() throws ContentIOException {
        InputStream result = this.delegatee.getContentInputStream();
        if (this.releaseableResource == null) {
            this.releaseableResource = result;
        }
        return result;
    }

    public String getContentString() throws ContentIOException {
        return this.delegatee.getContentString();
    }

    public String getContentString(int length) throws ContentIOException {
        return this.delegatee.getContentString(length);
    }

    public FileChannel getFileChannel() throws ContentIOException {
        FileChannel result = this.delegatee.getFileChannel();
        if (this.releaseableResource == null) {
            this.releaseableResource = result;
        }
        return result;
    }

    public long getLastModified() {
        return this.delegatee.getLastModified();
    }

    public ReadableByteChannel getReadableChannel() throws ContentIOException {
        ReadableByteChannel result = this.delegatee.getReadableChannel();
        if (this.releaseableResource == null) {
            this.releaseableResource = result;
        }
        return result;
    }

    public ContentReader getReader() throws ContentIOException {
        return this.delegatee.getReader();
    }

    public boolean isClosed() {
        return this.delegatee.isClosed();
    }

    public void addListener(ContentStreamListener listener) {
        this.delegatee.addListener(listener);
    }

    public ContentData getContentData() {
        return this.delegatee.getContentData();
    }

    public String getContentUrl() {
        return this.delegatee.getContentUrl();
    }

    public String getEncoding() {
        return this.delegatee.getEncoding();
    }

    public Locale getLocale() {
        return this.delegatee.getLocale();
    }

    public String getMimetype() {
        return this.delegatee.getMimetype();
    }

    public long getSize() {
        return this.delegatee.getSize();
    }

    public boolean isChannelOpen() {
        return this.delegatee.isChannelOpen();
    }

    public void setEncoding(String encoding) {
        this.delegatee.setEncoding(encoding);
    }

    public void setLocale(Locale locale) {
        this.delegatee.setLocale(locale);
    }

    public void setMimetype(String mimetype) {
        this.delegatee.setMimetype(mimetype);
    }

    @Override
    public boolean canBeClosed() {
        return this.delegatee.isChannelOpen();
    }

    @Override
    public Closeable getStream() {
        return this.releaseableResource;
    }
}

